/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.graphql.test.autoconfigure;

import graphql.execution.instrumentation.Instrumentation;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.graphql.autoconfigure.GraphQlSourceBuilderCustomizer;
import org.springframework.boot.graphql.test.autoconfigure.GraphQlTest;
import org.springframework.boot.jackson.JacksonComponent;
import org.springframework.boot.test.context.filter.annotation.StandardAnnotationCustomizableTypeExcludeFilter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.graphql.execution.DataFetcherExceptionResolver;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;
import org.springframework.stereotype.Controller;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

class GraphQlTypeExcludeFilter
extends StandardAnnotationCustomizableTypeExcludeFilter<GraphQlTest> {
    private static final Class<?>[] NO_CONTROLLERS = new Class[0];
    private static final String[] OPTIONAL_INCLUDES = new String[]{"tools.jackson.databind.JacksonModule"};
    private static final Set<Class<?>> KNOWN_INCLUDES;
    private static final Set<Class<?>> KNOWN_INCLUDES_AND_CONTROLLER;
    private final Class<?>[] controllers = this.getAnnotation().getValue("controllers", Class[].class).orElse(NO_CONTROLLERS);

    GraphQlTypeExcludeFilter(Class<?> testClass) {
        super(testClass);
    }

    protected Set<Class<?>> getKnownIncludes() {
        if (ObjectUtils.isEmpty((Object[])this.controllers)) {
            return KNOWN_INCLUDES_AND_CONTROLLER;
        }
        return KNOWN_INCLUDES;
    }

    protected Set<Class<?>> getComponentIncludes() {
        return new LinkedHashSet(Arrays.asList(this.controllers));
    }

    static {
        LinkedHashSet<Object> includes = new LinkedHashSet<Class>();
        includes.add(JacksonComponent.class);
        includes.add(RuntimeWiringConfigurer.class);
        includes.add(Converter.class);
        includes.add(GenericConverter.class);
        includes.add(DataFetcherExceptionResolver.class);
        includes.add(Instrumentation.class);
        includes.add(GraphQlSourceBuilderCustomizer.class);
        for (String optionalInclude : OPTIONAL_INCLUDES) {
            try {
                includes.add(ClassUtils.forName((String)optionalInclude, null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        KNOWN_INCLUDES = Collections.unmodifiableSet(includes);
        includes = new LinkedHashSet(KNOWN_INCLUDES);
        includes.add(Controller.class);
        KNOWN_INCLUDES_AND_CONTROLLER = Collections.unmodifiableSet(includes);
    }
}

