/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.build.Cache;

public class CacheSpec {
    private final ObjectFactory objectFactory;
    private @Nullable Cache cache;

    @Inject
    public CacheSpec(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public @Nullable Cache asCache() {
        return this.cache;
    }

    public void volume(Action<VolumeCacheSpec> action) {
        if (this.cache != null) {
            throw new GradleException("Each image building cache can be configured only once");
        }
        VolumeCacheSpec spec = (VolumeCacheSpec)this.objectFactory.newInstance(VolumeCacheSpec.class, new Object[0]);
        action.execute((Object)spec);
        this.cache = Cache.volume((String)((String)spec.getName().get()));
    }

    public void bind(Action<BindCacheSpec> action) {
        if (this.cache != null) {
            throw new GradleException("Each image building cache can be configured only once");
        }
        BindCacheSpec spec = (BindCacheSpec)this.objectFactory.newInstance(BindCacheSpec.class, new Object[0]);
        action.execute((Object)spec);
        this.cache = Cache.bind((String)((String)spec.getSource().get()));
    }

    public static abstract class VolumeCacheSpec {
        @Input
        public abstract Property<String> getName();
    }

    public static abstract class BindCacheSpec {
        @Input
        public abstract Property<String> getSource();
    }
}

