/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.aot;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Cacheability can only be determined by a concrete implementation")
public abstract class AbstractAot
extends JavaExec {
    private final DirectoryProperty sourcesDir = this.getProject().getObjects().directoryProperty();
    private final DirectoryProperty resourcesDir = this.getProject().getObjects().directoryProperty();
    private final DirectoryProperty classesDir = this.getProject().getObjects().directoryProperty();
    private final Property<String> groupId = this.getProject().getObjects().property(String.class);
    private final Property<String> artifactId = this.getProject().getObjects().property(String.class);

    protected AbstractAot() {
    }

    @Input
    public final Property<String> getGroupId() {
        return this.groupId;
    }

    @Input
    public final Property<String> getArtifactId() {
        return this.artifactId;
    }

    @OutputDirectory
    public final DirectoryProperty getSourcesOutput() {
        return this.sourcesDir;
    }

    @OutputDirectory
    public final DirectoryProperty getResourcesOutput() {
        return this.resourcesDir;
    }

    @OutputDirectory
    public final DirectoryProperty getClassesOutput() {
        return this.classesDir;
    }

    List<String> processorArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(((File)this.getSourcesOutput().getAsFile().get()).getAbsolutePath());
        args.add(((File)this.getResourcesOutput().getAsFile().get()).getAbsolutePath());
        args.add(((File)this.getClassesOutput().getAsFile().get()).getAbsolutePath());
        args.add((String)this.getGroupId().get());
        args.add((String)this.getArtifactId().get());
        args.addAll(super.getArgs());
        return args;
    }
}

