/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapper;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;
import org.springframework.boot.gradle.plugin.PluginApplicationAction;
import org.springframework.boot.gradle.plugin.SpringBootAotPlugin;

class KotlinPluginAction
implements PluginApplicationAction {
    KotlinPluginAction() {
    }

    public void execute(Project project) {
        this.configureKotlinVersionProperty(project);
        this.enableJavaParametersOption(project);
        this.repairDamageToAotCompileConfigurations(project);
    }

    private void configureKotlinVersionProperty(Project project) {
        ExtraPropertiesExtension extraProperties = project.getExtensions().getExtraProperties();
        if (!extraProperties.has("kotlin.version")) {
            String kotlinVersion = this.getKotlinVersion(project);
            extraProperties.set("kotlin.version", (Object)kotlinVersion);
        }
    }

    private String getKotlinVersion(Project project) {
        return KotlinPluginWrapperKt.getKotlinPluginVersion((Project)project);
    }

    private void enableJavaParametersOption(Project project) {
        project.getTasks().withType(KotlinCompile.class).configureEach(compile -> compile.getKotlinOptions().setJavaParameters(true));
    }

    private void repairDamageToAotCompileConfigurations(Project project) {
        SpringBootAotPlugin aotPlugin = (SpringBootAotPlugin)project.getPlugins().findPlugin(SpringBootAotPlugin.class);
        if (aotPlugin != null) {
            aotPlugin.repairKotlinPluginDamage(project);
        }
    }

    @Override
    public Class<? extends Plugin<? extends Project>> getPluginClass() {
        return KotlinPluginWrapper.class;
    }
}

