/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.work.DisableCachingByDefault;
import org.springframework.boot.gradle.tasks.bundling.BootArchive;
import org.springframework.boot.gradle.tasks.bundling.BootArchiveSupport;
import org.springframework.boot.gradle.tasks.bundling.LaunchScriptConfiguration;
import org.springframework.boot.gradle.tasks.bundling.LayerResolver;
import org.springframework.boot.gradle.tasks.bundling.LayeredSpec;
import org.springframework.boot.gradle.tasks.bundling.ResolvedDependencies;
import org.springframework.boot.gradle.tasks.bundling.ZipCompression;
import org.springframework.boot.loader.tools.LoaderImplementation;

@DisableCachingByDefault(because="Not worth caching")
public abstract class BootJar
extends Jar
implements BootArchive {
    private static final String LAUNCHER = "org.springframework.boot.loader.launch.JarLauncher";
    private static final String CLASSES_DIRECTORY = "BOOT-INF/classes/";
    private static final String LIB_DIRECTORY = "BOOT-INF/lib/";
    private static final String LAYERS_INDEX = "BOOT-INF/layers.idx";
    private static final String CLASSPATH_INDEX = "BOOT-INF/classpath.idx";
    private final BootArchiveSupport support = new BootArchiveSupport("org.springframework.boot.loader.launch.JarLauncher", new LibrarySpec(), new ZipCompressionResolver());
    private final CopySpec bootInfSpec;
    private final LayeredSpec layered;
    private final Provider<String> projectName;
    private final Provider<Object> projectVersion;
    private final ResolvedDependencies resolvedDependencies;
    private FileCollection classpath;

    public BootJar() {
        Project project = this.getProject();
        this.bootInfSpec = project.copySpec().into((Object)"BOOT-INF");
        this.layered = (LayeredSpec)project.getObjects().newInstance(LayeredSpec.class, new Object[0]);
        this.configureBootInfSpec(this.bootInfSpec);
        this.getMainSpec().with(new CopySpec[]{this.bootInfSpec});
        this.projectName = project.provider(() -> ((Project)project).getName());
        this.projectVersion = project.provider(() -> ((Project)project).getVersion());
        this.resolvedDependencies = new ResolvedDependencies(project);
        this.getIncludeTools().convention((Object)true);
    }

    private void configureBootInfSpec(CopySpec bootInfSpec) {
        bootInfSpec.into((Object)"classes", BootJar.fromCallTo(this::classpathDirectories));
        bootInfSpec.into((Object)"lib", BootJar.fromCallTo(this::classpathFiles)).eachFile(this.support::excludeNonZipFiles);
        this.support.moveModuleInfoToRoot(bootInfSpec);
        this.moveMetaInfToRoot(bootInfSpec);
    }

    private Iterable<File> classpathDirectories() {
        return this.classpathEntries((Spec<File>)((Spec)File::isDirectory));
    }

    private Iterable<File> classpathFiles() {
        return this.classpathEntries((Spec<File>)((Spec)File::isFile));
    }

    private Iterable<File> classpathEntries(Spec<File> filter) {
        return this.classpath != null ? this.classpath.filter(filter) : Collections.emptyList();
    }

    private void moveMetaInfToRoot(CopySpec spec) {
        spec.eachFile(file -> {
            String path = file.getRelativeSourcePath().getPathString();
            if (path.startsWith("META-INF/") && !path.equals("META-INF/aop.xml") && !path.endsWith(".kotlin_module") && !path.startsWith("META-INF/services/")) {
                this.support.moveToRoot((FileCopyDetails)file);
            }
        });
    }

    @Override
    public void resolvedArtifacts(Provider<Set<ResolvedArtifactResult>> resolvedArtifacts) {
        this.resolvedDependencies.resolvedArtifacts(resolvedArtifacts);
    }

    @Nested
    ResolvedDependencies getResolvedDependencies() {
        return this.resolvedDependencies;
    }

    public void copy() {
        this.support.configureManifest(this.getManifest(), (String)this.getMainClass().get(), CLASSES_DIRECTORY, LIB_DIRECTORY, CLASSPATH_INDEX, this.isLayeredDisabled() ? null : LAYERS_INDEX, ((JavaVersion)this.getTargetJavaVersion().get()).getMajorVersion(), (String)this.projectName.get(), this.projectVersion.get());
        super.copy();
    }

    private boolean isLayeredDisabled() {
        return (Boolean)this.getLayered().getEnabled().get() == false;
    }

    protected CopyAction createCopyAction() {
        LoaderImplementation loaderImplementation = (LoaderImplementation)this.getLoaderImplementation().getOrElse((Object)LoaderImplementation.DEFAULT);
        LayerResolver layerResolver = null;
        if (!this.isLayeredDisabled()) {
            layerResolver = new LayerResolver(this.resolvedDependencies, this.layered, (Spec<FileCopyDetails>)((Spec)this::isLibrary));
        }
        String jarmodeToolsLocation = this.isIncludeJarmodeTools() ? LIB_DIRECTORY : null;
        return this.support.createCopyAction(this, this.resolvedDependencies, loaderImplementation, layerResolver, jarmodeToolsLocation);
    }

    private boolean isIncludeJarmodeTools() {
        return Boolean.TRUE.equals(this.getIncludeTools().get()) && Boolean.TRUE.equals(this.layered.getIncludeLayerTools().get());
    }

    @Override
    public void requiresUnpack(String ... patterns) {
        this.support.requiresUnpack(patterns);
    }

    @Override
    public void requiresUnpack(Spec<FileTreeElement> spec) {
        this.support.requiresUnpack(spec);
    }

    @Override
    public LaunchScriptConfiguration getLaunchScript() {
        return this.support.getLaunchScript();
    }

    @Override
    public void launchScript() {
        this.enableLaunchScriptIfNecessary();
    }

    @Override
    public void launchScript(Action<LaunchScriptConfiguration> action) {
        action.execute((Object)this.enableLaunchScriptIfNecessary());
    }

    @Nested
    public LayeredSpec getLayered() {
        return this.layered;
    }

    public void layered(Action<LayeredSpec> action) {
        action.execute((Object)this.layered);
    }

    @Override
    public FileCollection getClasspath() {
        return this.classpath;
    }

    @Override
    public void classpath(Object ... classpath) {
        FileCollection existingClasspath = this.classpath;
        this.classpath = this.getProject().files(new Object[]{existingClasspath != null ? existingClasspath : Collections.emptyList(), classpath});
    }

    @Override
    public void setClasspath(Object classpath) {
        this.classpath = this.getProject().files(new Object[]{classpath});
    }

    @Override
    public void setClasspath(FileCollection classpath) {
        this.classpath = this.getProject().files(new Object[]{classpath});
    }

    @Internal
    public CopySpec getBootInf() {
        CopySpec child = this.getProject().copySpec();
        this.bootInfSpec.with(new CopySpec[]{child});
        return child;
    }

    public CopySpec bootInf(Action<CopySpec> action) {
        CopySpec bootInf = this.getBootInf();
        action.execute((Object)bootInf);
        return bootInf;
    }

    protected ZipCompression resolveZipCompression(FileCopyDetails details) {
        return this.isLibrary(details) ? ZipCompression.STORED : ZipCompression.DEFLATED;
    }

    protected boolean isLibrary(FileCopyDetails details) {
        String path = details.getRelativePath().getPathString();
        return path.startsWith(LIB_DIRECTORY);
    }

    private LaunchScriptConfiguration enableLaunchScriptIfNecessary() {
        LaunchScriptConfiguration launchScript = this.support.getLaunchScript();
        if (launchScript == null) {
            launchScript = new LaunchScriptConfiguration((AbstractArchiveTask)this);
            this.support.setLaunchScript(launchScript);
        }
        return launchScript;
    }

    private static <T> Action<CopySpec> fromCallTo(Callable<T> callable) {
        return spec -> spec.from(new Object[]{BootJar.callTo(callable)});
    }

    private static <T> Callable<T> callTo(Callable<T> callable) {
        return callable;
    }

    private final class LibrarySpec
    implements Spec<FileCopyDetails> {
        private LibrarySpec() {
        }

        public boolean isSatisfiedBy(FileCopyDetails details) {
            return BootJar.this.isLibrary(details);
        }
    }

    private final class ZipCompressionResolver
    implements Function<FileCopyDetails, ZipCompression> {
        private ZipCompressionResolver() {
        }

        @Override
        public ZipCompression apply(FileCopyDetails details) {
            return BootJar.this.resolveZipCompression(details);
        }
    }
}

