/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.buildinfo;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.util.GradleVersion;

public class BuildInfoProperties
implements Serializable {
    private static final GradleVersion GRADLE_7_4 = GradleVersion.version((String)"7.4");
    private transient Instant creationTime = Instant.now();
    private final Property<String> group;
    private final Property<String> artifact;
    private final Property<String> version;
    private final Property<String> name;
    private final Property<Long> time;
    private boolean timeConfigured = false;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    BuildInfoProperties(Project project) {
        this.time = project.getObjects().property(Long.class);
        this.group = project.getObjects().property(String.class);
        this.group.set(project.provider(() -> project.getGroup().toString()));
        this.artifact = project.getObjects().property(String.class);
        this.version = project.getObjects().property(String.class);
        this.version.set(this.projectVersion(project));
        this.name = project.getObjects().property(String.class);
        this.name.set(project.provider(() -> ((Project)project).getName()));
    }

    private Provider<String> projectVersion(Project project) {
        Provider<String> externalVersionProperty = this.forUseAtConfigurationTime((Provider<String>)project.getProviders().gradleProperty("version"));
        externalVersionProperty.getOrNull();
        return project.provider(() -> project.getVersion().toString());
    }

    private Provider<String> forUseAtConfigurationTime(Provider<String> provider) {
        if (GradleVersion.current().compareTo(GRADLE_7_4) < 0) {
            return provider.forUseAtConfigurationTime();
        }
        return provider;
    }

    @Input
    @Optional
    public String getGroup() {
        return (String)this.group.getOrNull();
    }

    public void setGroup(String group) {
        this.group.set((Object)group);
    }

    @Input
    @Optional
    public String getArtifact() {
        return (String)this.artifact.getOrNull();
    }

    public void setArtifact(String artifact) {
        this.artifact.set((Object)artifact);
    }

    @Input
    @Optional
    public String getVersion() {
        return (String)this.version.getOrNull();
    }

    public void setVersion(String version) {
        this.version.set((Object)version);
    }

    @Input
    @Optional
    public String getName() {
        return (String)this.name.getOrNull();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    @Input
    @Optional
    public Instant getTime() {
        Long epochMillis = (Long)this.time.getOrNull();
        if (epochMillis != null) {
            return Instant.ofEpochMilli(epochMillis);
        }
        if (this.timeConfigured) {
            return null;
        }
        return this.creationTime;
    }

    public void setTime(Instant time) {
        this.timeConfigured = true;
        this.time.set(time != null ? Long.valueOf(time.toEpochMilli()) : null);
    }

    @Input
    @Optional
    public Map<String, Object> getAdditional() {
        return this.additionalProperties;
    }

    public void setAdditional(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    private void readObject(ObjectInputStream input) throws ClassNotFoundException, IOException {
        input.defaultReadObject();
        this.creationTime = Instant.now();
    }
}

