/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.util.GradleVersion;
import org.springframework.boot.gradle.dsl.SpringBootExtension;
import org.springframework.boot.gradle.plugin.ApplicationPluginAction;
import org.springframework.boot.gradle.plugin.DependencyManagementPluginAction;
import org.springframework.boot.gradle.plugin.JavaPluginAction;
import org.springframework.boot.gradle.plugin.KotlinPluginAction;
import org.springframework.boot.gradle.plugin.PluginApplicationAction;
import org.springframework.boot.gradle.plugin.SinglePublishedArtifact;
import org.springframework.boot.gradle.plugin.WarPluginAction;
import org.springframework.boot.gradle.util.VersionExtractor;

public class SpringBootPlugin
implements Plugin<Project> {
    private static final String SPRING_BOOT_VERSION = VersionExtractor.forClass(DependencyManagementPluginAction.class);
    public static final String BOOT_ARCHIVES_CONFIGURATION_NAME = "bootArchives";
    public static final String BOOT_JAR_TASK_NAME = "bootJar";
    public static final String BOOT_WAR_TASK_NAME = "bootWar";
    public static final String BOOT_BUILD_IMAGE_TASK_NAME = "bootBuildImage";
    static final String BOOT_RUN_TASK_NAME = "bootRun";
    public static final String DEVELOPMENT_ONLY_CONFIGURATION_NAME = "developmentOnly";
    public static final String PRODUCTION_RUNTIME_CLASSPATH_CONFIGURATION_NAME = "productionRuntimeClasspath";
    public static final String BOM_COORDINATES = "org.springframework.boot:spring-boot-dependencies:" + SPRING_BOOT_VERSION;

    public void apply(Project project) {
        this.verifyGradleVersion();
        this.createExtension(project);
        Configuration bootArchives = this.createBootArchivesConfiguration(project);
        this.registerPluginActions(project, bootArchives);
    }

    private void verifyGradleVersion() {
        GradleVersion currentVersion = GradleVersion.current();
        if (currentVersion.compareTo(GradleVersion.version((String)"6.8")) < 0) {
            throw new GradleException("Spring Boot plugin requires Gradle 6.8.x, 6.9.x, or 7.x. The current version is " + currentVersion);
        }
    }

    private void createExtension(Project project) {
        project.getExtensions().create("springBoot", SpringBootExtension.class, new Object[]{project});
    }

    private Configuration createBootArchivesConfiguration(Project project) {
        Configuration bootArchives = (Configuration)project.getConfigurations().create(BOOT_ARCHIVES_CONFIGURATION_NAME);
        bootArchives.setDescription("Configuration for Spring Boot archive artifacts.");
        bootArchives.setCanBeResolved(false);
        return bootArchives;
    }

    private void registerPluginActions(Project project, Configuration bootArchives) {
        SinglePublishedArtifact singlePublishedArtifact = new SinglePublishedArtifact(bootArchives, project.getArtifacts());
        List<PluginApplicationAction> actions = Arrays.asList(new JavaPluginAction(singlePublishedArtifact), new WarPluginAction(singlePublishedArtifact), new DependencyManagementPluginAction(), new ApplicationPluginAction(), new KotlinPluginAction());
        for (PluginApplicationAction action : actions) {
            this.withPluginClassOfAction(action, pluginClass -> project.getPlugins().withType(pluginClass, plugin -> action.execute(project)));
        }
    }

    private void withPluginClassOfAction(PluginApplicationAction action, Consumer<Class<? extends Plugin<? extends Project>>> consumer) {
        Class<? extends Plugin<? extends Project>> pluginClass;
        try {
            pluginClass = action.getPluginClass();
        }
        catch (Throwable ex) {
            return;
        }
        consumer.accept(pluginClass);
    }
}

