/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.concurrent.Callable;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.distribution.Distribution;
import org.gradle.api.distribution.DistributionContainer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ApplicationPlugin;
import org.gradle.api.plugins.JavaApplication;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.application.scripts.TemplateBasedScriptGenerator;
import org.gradle.jvm.application.tasks.CreateStartScripts;
import org.springframework.boot.gradle.plugin.PluginApplicationAction;
import org.springframework.boot.gradle.tasks.run.BootRun;

final class ApplicationPluginAction
implements PluginApplicationAction {
    ApplicationPluginAction() {
    }

    public void execute(Project project) {
        JavaApplication javaApplication = (JavaApplication)project.getExtensions().getByType(JavaApplication.class);
        DistributionContainer distributions = (DistributionContainer)project.getExtensions().getByType(DistributionContainer.class);
        Distribution distribution = (Distribution)distributions.create("boot");
        distribution.getDistributionBaseName().convention(project.provider(() -> javaApplication.getApplicationName() + "-boot"));
        TaskProvider bootStartScripts = project.getTasks().register("bootStartScripts", CreateStartScripts.class, task -> this.configureCreateStartScripts(project, javaApplication, distribution, (CreateStartScripts)task));
        CopySpec binCopySpec = project.copySpec().into((Object)"bin").from(new Object[]{bootStartScripts});
        binCopySpec.setFileMode(Integer.valueOf(493));
        distribution.getContents().with(new CopySpec[]{binCopySpec});
        project.getTasks().named("bootRun", BootRun.class).configure(bootRun -> bootRun.getConventionMapping().map("jvmArgs", () -> ((JavaApplication)javaApplication).getApplicationDefaultJvmArgs()));
    }

    private void configureCreateStartScripts(Project project, JavaApplication javaApplication, Distribution distribution, CreateStartScripts createStartScripts) {
        createStartScripts.setDescription("Generates OS-specific start scripts to run the project as a Spring Boot application.");
        ((TemplateBasedScriptGenerator)createStartScripts.getUnixStartScriptGenerator()).setTemplate(project.getResources().getText().fromString(this.loadResource("/unixStartScript.txt")));
        ((TemplateBasedScriptGenerator)createStartScripts.getWindowsStartScriptGenerator()).setTemplate(project.getResources().getText().fromString(this.loadResource("/windowsStartScript.txt")));
        project.getConfigurations().all(configuration -> {
            if ("bootArchives".equals(configuration.getName())) {
                distribution.getContents().with(new CopySpec[]{this.artifactFilesToLibCopySpec(project, (Configuration)configuration)});
                createStartScripts.setClasspath(configuration.getArtifacts().getFiles());
            }
        });
        createStartScripts.getConventionMapping().map("outputDir", () -> new File(project.getBuildDir(), "bootScripts"));
        createStartScripts.getConventionMapping().map("applicationName", () -> ((JavaApplication)javaApplication).getApplicationName());
        createStartScripts.getConventionMapping().map("defaultJvmOpts", () -> ((JavaApplication)javaApplication).getApplicationDefaultJvmArgs());
    }

    private CopySpec artifactFilesToLibCopySpec(Project project, Configuration configuration) {
        CopySpec copySpec = project.copySpec().into((Object)"lib").from(new Object[]{this.artifactFiles(configuration)});
        copySpec.setFileMode(Integer.valueOf(420));
        return copySpec;
    }

    private Callable<FileCollection> artifactFiles(Configuration configuration) {
        return () -> configuration.getArtifacts().getFiles();
    }

    public Class<? extends Plugin<Project>> getPluginClass() {
        return ApplicationPlugin.class;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadResource(String name) {
        try (InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(name));){
            int read;
            char[] buffer = new char[4096];
            StringWriter writer = new StringWriter();
            while ((read = reader.read(buffer)) > 0) {
                writer.write(buffer, 0, read);
            }
            String string = writer.toString();
            return string;
        }
        catch (IOException ex) {
            throw new GradleException("Failed to read '" + name + "'", (Throwable)ex);
        }
    }
}

