/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.dsl;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.tasks.Jar;
import org.springframework.boot.gradle.tasks.buildinfo.BuildInfo;
import org.springframework.boot.gradle.tasks.buildinfo.BuildInfoProperties;

public class SpringBootExtension {
    private final Project project;
    private final Property<String> mainClass;

    public SpringBootExtension(Project project) {
        this.project = project;
        this.mainClass = this.project.getObjects().property(String.class);
    }

    public Property<String> getMainClass() {
        return this.mainClass;
    }

    public void buildInfo() {
        this.buildInfo(null);
    }

    public void buildInfo(Action<BuildInfo> configurer) {
        TaskContainer tasks = this.project.getTasks();
        TaskProvider bootBuildInfo = tasks.register("bootBuildInfo", BuildInfo.class, this::configureBuildInfoTask);
        this.project.getPlugins().withType(JavaPlugin.class, plugin -> {
            tasks.named("classes").configure(task -> task.dependsOn(new Object[]{bootBuildInfo}));
            this.project.afterEvaluate(evaluated -> bootBuildInfo.configure(buildInfo -> {
                BuildInfoProperties properties = buildInfo.getProperties();
                if (properties.getArtifact() == null) {
                    properties.setArtifact(this.determineArtifactBaseName());
                }
            }));
        });
        if (configurer != null) {
            bootBuildInfo.configure(configurer);
        }
    }

    private void configureBuildInfoTask(BuildInfo task) {
        task.setGroup("build");
        task.setDescription("Generates a META-INF/build-info.properties file.");
        task.getConventionMapping().map("destinationDir", () -> new File(this.determineMainSourceSetResourcesOutputDir(), "META-INF"));
    }

    private File determineMainSourceSetResourcesOutputDir() {
        return ((SourceSet)this.sourceSets(this.project).getByName("main")).getOutput().getResourcesDir();
    }

    private SourceSetContainer sourceSets(Project project) {
        return ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
    }

    private String determineArtifactBaseName() {
        Jar artifactTask = this.findArtifactTask();
        return artifactTask != null ? (String)artifactTask.getArchiveBaseName().get() : null;
    }

    private Jar findArtifactTask() {
        Jar artifactTask = (Jar)this.project.getTasks().findByName("bootWar");
        if (artifactTask != null) {
            return artifactTask;
        }
        return (Jar)this.project.getTasks().findByName("bootJar");
    }
}

