/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.util.Collections;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.War;
import org.springframework.boot.gradle.tasks.bundling.BootArchive;
import org.springframework.boot.gradle.tasks.bundling.BootArchiveSupport;
import org.springframework.boot.gradle.tasks.bundling.LaunchScriptConfiguration;
import org.springframework.boot.gradle.tasks.bundling.ZipCompression;

public class BootWar
extends War
implements BootArchive {
    private final BootArchiveSupport support = new BootArchiveSupport("org.springframework.boot.loader.WarLauncher", this::resolveZipCompression);
    private String mainClassName;
    private FileCollection providedClasspath;

    public BootWar() {
        this.getWebInf().into((Object)"lib-provided", copySpec -> copySpec.from(new Object[]{() -> this.providedClasspath == null ? Collections.emptyList() : this.providedClasspath}));
    }

    public void copy() {
        this.support.configureManifest((Jar)this, this.getMainClassName());
        super.copy();
    }

    protected CopyAction createCopyAction() {
        return this.support.createCopyAction((Jar)this);
    }

    @Override
    public String getMainClassName() {
        return this.mainClassName;
    }

    @Override
    public void setMainClassName(String mainClass) {
        this.mainClassName = mainClass;
    }

    @Override
    public void requiresUnpack(String ... patterns) {
        this.support.requiresUnpack(patterns);
    }

    @Override
    public void requiresUnpack(Spec<FileTreeElement> spec) {
        this.support.requiresUnpack(spec);
    }

    @Override
    public LaunchScriptConfiguration getLaunchScript() {
        return this.support.getLaunchScript();
    }

    @Override
    public void launchScript() {
        this.enableLaunchScriptIfNecessary();
    }

    @Override
    public void launchScript(Action<LaunchScriptConfiguration> action) {
        action.execute((Object)this.enableLaunchScriptIfNecessary());
    }

    @Optional
    public FileCollection getProvidedClasspath() {
        return this.providedClasspath;
    }

    public void providedClasspath(Object ... classpath) {
        FileCollection existingClasspath = this.providedClasspath;
        this.providedClasspath = this.getProject().files(new Object[]{existingClasspath == null ? Collections.emptyList() : existingClasspath, classpath});
    }

    @Override
    public boolean isExcludeDevtools() {
        return this.support.isExcludeDevtools();
    }

    @Override
    public void setExcludeDevtools(boolean excludeDevtools) {
        this.support.setExcludeDevtools(excludeDevtools);
    }

    protected ZipCompression resolveZipCompression(FileCopyDetails details) {
        String relativePath = details.getRelativePath().getPathString();
        if (relativePath.startsWith("WEB-INF/lib/") || relativePath.startsWith("WEB-INF/lib-provided/")) {
            return ZipCompression.STORED;
        }
        return ZipCompression.DEFLATED;
    }

    private LaunchScriptConfiguration enableLaunchScriptIfNecessary() {
        LaunchScriptConfiguration launchScript = this.support.getLaunchScript();
        if (launchScript == null) {
            launchScript = new LaunchScriptConfiguration();
            this.support.setLaunchScript(launchScript);
        }
        return launchScript;
    }
}

