/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.elasticsearch.autoconfigure;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.elasticsearch")
public class ElasticsearchProperties {
    private List<String> uris = new ArrayList<String>(Collections.singletonList("http://localhost:9200"));
    private @Nullable String username;
    private @Nullable String password;
    private @Nullable String apiKey;
    private Duration connectionTimeout = Duration.ofSeconds(1L);
    private Duration socketTimeout = Duration.ofSeconds(30L);
    private boolean socketKeepAlive = true;
    private @Nullable String pathPrefix;
    private final Restclient restclient = new Restclient();

    public List<String> getUris() {
        return this.uris;
    }

    public void setUris(List<String> uris) {
        this.uris = uris;
    }

    public @Nullable String getUsername() {
        return this.username;
    }

    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    public @Nullable String getPassword() {
        return this.password;
    }

    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    public @Nullable String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(@Nullable String apiKey) {
        this.apiKey = apiKey;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Duration getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(Duration socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public boolean isSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public void setSocketKeepAlive(boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
    }

    public @Nullable String getPathPrefix() {
        return this.pathPrefix;
    }

    public void setPathPrefix(@Nullable String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    public Restclient getRestclient() {
        return this.restclient;
    }

    public static class Restclient {
        private final Sniffer sniffer = new Sniffer();
        private final Ssl ssl = new Ssl();

        public Sniffer getSniffer() {
            return this.sniffer;
        }

        public Ssl getSsl() {
            return this.ssl;
        }

        public static class Sniffer {
            private boolean enabled;
            private Duration interval = Duration.ofMinutes(5L);
            private Duration delayAfterFailure = Duration.ofMinutes(1L);

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public Duration getInterval() {
                return this.interval;
            }

            public void setInterval(Duration interval) {
                this.interval = interval;
            }

            public Duration getDelayAfterFailure() {
                return this.delayAfterFailure;
            }

            public void setDelayAfterFailure(Duration delayAfterFailure) {
                this.delayAfterFailure = delayAfterFailure;
            }
        }

        public static class Ssl {
            private @Nullable String bundle;

            public @Nullable String getBundle() {
                return this.bundle;
            }

            public void setBundle(@Nullable String bundle) {
                this.bundle = bundle;
            }
        }
    }
}

