/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.elasticsearch.autoconfigure;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.SimpleJsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.json.jsonb.JsonbJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest5_client.Rest5ClientOptions;
import co.elastic.clients.transport.rest5_client.Rest5ClientTransport;
import co.elastic.clients.transport.rest5_client.low_level.Rest5Client;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.bind.Jsonb;
import jakarta.json.spi.JsonProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

class ElasticsearchClientConfigurations {
    ElasticsearchClientConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={ElasticsearchTransport.class})
    static class ElasticsearchClientConfiguration {
        ElasticsearchClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ElasticsearchClient elasticsearchClient(ElasticsearchTransport transport) {
            return new ElasticsearchClient(transport);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={ElasticsearchTransport.class})
    static class ElasticsearchTransportConfiguration {
        ElasticsearchTransportConfiguration() {
        }

        @Bean
        Rest5ClientTransport restClientTransport(Rest5Client restClient, JsonpMapper jsonMapper, ObjectProvider<Rest5ClientOptions> restClientOptions) {
            return new Rest5ClientTransport(restClient, jsonMapper, (Rest5ClientOptions)restClientOptions.getIfAvailable());
        }
    }

    @ConditionalOnMissingBean(value={JsonpMapper.class})
    @Configuration(proxyBeanMethods=false)
    static class SimpleJsonpMapperConfiguration {
        SimpleJsonpMapperConfiguration() {
        }

        @Bean
        SimpleJsonpMapper simpleJsonpMapper() {
            return new SimpleJsonpMapper();
        }
    }

    @ConditionalOnMissingBean(value={JsonpMapper.class})
    @ConditionalOnBean(value={Jsonb.class})
    @Configuration(proxyBeanMethods=false)
    static class JsonbJsonpMapperConfiguration {
        JsonbJsonpMapperConfiguration() {
        }

        @Bean
        JsonbJsonpMapper jsonbJsonpMapper(Jsonb jsonb) {
            return new JsonbJsonpMapper(JsonProvider.provider(), jsonb);
        }
    }

    @ConditionalOnMissingBean(value={JsonpMapper.class})
    @ConditionalOnClass(value={ObjectMapper.class})
    @Configuration(proxyBeanMethods=false)
    static class JacksonJsonpMapperConfiguration {
        JacksonJsonpMapperConfiguration() {
        }

        @Bean
        JacksonJsonpMapper jacksonJsonpMapper() {
            return new JacksonJsonpMapper();
        }
    }

    @Import(value={JacksonJsonpMapperConfiguration.class, JsonbJsonpMapperConfiguration.class, SimpleJsonpMapperConfiguration.class})
    static class JsonpMapperConfiguration {
        JsonpMapperConfiguration() {
        }
    }
}

