/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.docker.compose.core.ConnectionPorts;
import org.springframework.boot.docker.compose.core.DockerCliInspectResponse;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

class DefaultConnectionPorts
implements ConnectionPorts {
    private final Map<ContainerPort, Integer> mappings;
    private final Map<Integer, Integer> portMappings;

    DefaultConnectionPorts(DockerCliInspectResponse inspectResponse) {
        this.mappings = !DefaultConnectionPorts.isHostNetworkMode(inspectResponse) ? this.buildMappingsForNetworkSettings(inspectResponse.networkSettings()) : this.buildMappingsForHostNetworking(inspectResponse.config());
        HashMap portMappings = new HashMap();
        this.mappings.forEach((containerPort, hostPort) -> portMappings.put(containerPort.number(), hostPort));
        this.portMappings = Collections.unmodifiableMap(portMappings);
    }

    private static boolean isHostNetworkMode(DockerCliInspectResponse inspectResponse) {
        DockerCliInspectResponse.HostConfig config = inspectResponse.hostConfig();
        return config != null && "host".equals(config.networkMode());
    }

    private Map<ContainerPort, Integer> buildMappingsForNetworkSettings(@Nullable DockerCliInspectResponse.NetworkSettings networkSettings) {
        if (networkSettings == null || CollectionUtils.isEmpty(networkSettings.ports())) {
            return Collections.emptyMap();
        }
        HashMap mappings = new HashMap();
        networkSettings.ports().forEach((containerPortString, hostPorts) -> {
            if (!CollectionUtils.isEmpty((Collection)hostPorts)) {
                ContainerPort containerPort = ContainerPort.parse(containerPortString);
                hostPorts.stream().filter(this::isIpV4).forEach(hostPort -> mappings.put(containerPort, DefaultConnectionPorts.getPortNumber(hostPort)));
            }
        });
        return Collections.unmodifiableMap(mappings);
    }

    private boolean isIpV4(@Nullable DockerCliInspectResponse.HostPort hostPort) {
        String ip = hostPort != null ? hostPort.hostIp() : null;
        return !StringUtils.hasLength((String)ip) || ip.contains(".");
    }

    private static int getPortNumber(DockerCliInspectResponse.HostPort hostPort) {
        return Integer.parseInt(hostPort.hostPort());
    }

    private Map<ContainerPort, Integer> buildMappingsForHostNetworking(DockerCliInspectResponse.Config config) {
        if (CollectionUtils.isEmpty(config.exposedPorts())) {
            return Collections.emptyMap();
        }
        HashMap<ContainerPort, Integer> mappings = new HashMap<ContainerPort, Integer>();
        for (String entry : config.exposedPorts().keySet()) {
            ContainerPort containerPort = ContainerPort.parse(entry);
            mappings.put(containerPort, containerPort.number());
        }
        return Collections.unmodifiableMap(mappings);
    }

    @Override
    public int get(int containerPort) {
        Integer hostPort = this.portMappings.get(containerPort);
        Assert.state((hostPort != null ? 1 : 0) != 0, () -> "No host port mapping found for container port %s".formatted(containerPort));
        return hostPort;
    }

    @Override
    public List<Integer> getAll() {
        return this.getAll(null);
    }

    @Override
    public List<Integer> getAll(@Nullable String protocol) {
        ArrayList hostPorts = new ArrayList();
        this.mappings.forEach((containerPort, hostPort) -> {
            if (protocol == null || protocol.equalsIgnoreCase(containerPort.protocol())) {
                hostPorts.add(hostPort);
            }
        });
        return Collections.unmodifiableList(hostPorts);
    }

    Map<ContainerPort, Integer> getMappings() {
        return this.mappings;
    }

    record ContainerPort(int number, String protocol) {
        @Override
        public String toString() {
            return "%d/%s".formatted(this.number, this.protocol);
        }

        static ContainerPort parse(String value) {
            try {
                String[] parts = value.split("/");
                Assert.state((parts.length == 2 ? 1 : 0) != 0, (String)"Unable to split string");
                return new ContainerPort(Integer.parseInt(parts[0]), parts[1]);
            }
            catch (RuntimeException ex) {
                throw new IllegalStateException("Unable to parse container port '%s'".formatted(value), ex);
            }
        }
    }
}

