/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.docker.compose.core.ProcessExitException;
import org.springframework.boot.docker.compose.core.ProcessStartException;
import org.springframework.core.log.LogMessage;

class ProcessRunner {
    private static final String USR_LOCAL_BIN = "/usr/local/bin";
    private static final boolean MAC_OS = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac");
    private static final Log logger = LogFactory.getLog(ProcessRunner.class);
    private final @Nullable File workingDirectory;

    ProcessRunner() {
        this(null);
    }

    ProcessRunner(@Nullable File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    String run(String ... command) {
        return this.run((Consumer<String>)null, command);
    }

    String run(@Nullable Consumer<String> outputConsumer, String ... command) {
        logger.trace((Object)LogMessage.of(() -> "Running '%s'".formatted(String.join((CharSequence)" ", command))));
        Process process = this.startProcess(command);
        ReaderThread stdOutReader = new ReaderThread(process.getInputStream(), "stdout", outputConsumer);
        ReaderThread stdErrReader = new ReaderThread(process.getErrorStream(), "stderr", outputConsumer);
        logger.trace((Object)"Waiting for process exit");
        int exitCode = this.waitForProcess(process);
        logger.trace((Object)LogMessage.format((String)"Process exited with exit code %d", (Object)exitCode));
        String stdOut = stdOutReader.toString();
        String stdErr = stdErrReader.toString();
        if (exitCode != 0) {
            throw new ProcessExitException(exitCode, command, stdOut, stdErr);
        }
        return stdOut;
    }

    private Process startProcess(String[] command) {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.directory(this.workingDirectory);
        try {
            return processBuilder.start();
        }
        catch (IOException ex) {
            String path = processBuilder.environment().get("PATH");
            if (MAC_OS && path != null && !path.contains(USR_LOCAL_BIN) && !command[0].startsWith("/usr/local/bin/")) {
                String[] localCommand = (String[])command.clone();
                localCommand[0] = "/usr/local/bin/" + localCommand[0];
                return this.startProcess(localCommand);
            }
            throw new ProcessStartException(command, ex);
        }
    }

    private int waitForProcess(Process process) {
        try {
            return process.waitFor();
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("Interrupted waiting for %s".formatted(process));
        }
    }

    private static class ReaderThread
    extends Thread {
        private final InputStream source;
        private final @Nullable Consumer<String> outputConsumer;
        private final StringBuilder output = new StringBuilder();
        private final CountDownLatch latch = new CountDownLatch(1);

        ReaderThread(InputStream source, String name, @Nullable Consumer<String> outputConsumer) {
            this.source = source;
            this.outputConsumer = outputConsumer;
            this.setName("OutputReader-" + name);
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.source, StandardCharsets.UTF_8));){
                String line = reader.readLine();
                while (line != null) {
                    this.output.append(line);
                    this.output.append("\n");
                    if (this.outputConsumer != null) {
                        this.outputConsumer.accept(line);
                    }
                    line = reader.readLine();
                }
                this.latch.countDown();
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Failed to read process stream", ex);
            }
        }

        @Override
        public String toString() {
            try {
                this.latch.await();
                return this.output.toString();
            }
            catch (InterruptedException ex) {
                return "";
            }
        }
    }
}

