/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.lifecycle;

import java.util.Set;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationShutdownHandlers;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.docker.compose.lifecycle.DockerComposeLifecycleManager;
import org.springframework.boot.docker.compose.lifecycle.DockerComposeProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;

class DockerComposeListener
implements ApplicationListener<ApplicationPreparedEvent> {
    private final SpringApplicationShutdownHandlers shutdownHandlers;

    DockerComposeListener() {
        this(SpringApplication.getShutdownHandlers());
    }

    DockerComposeListener(SpringApplicationShutdownHandlers shutdownHandlers) {
        this.shutdownHandlers = shutdownHandlers;
    }

    public void onApplicationEvent(ApplicationPreparedEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Binder binder = Binder.get((Environment)applicationContext.getEnvironment());
        DockerComposeProperties properties = DockerComposeProperties.get(binder);
        Set eventListeners = event.getSpringApplication().getListeners();
        this.createDockerComposeLifecycleManager(applicationContext, binder, properties, eventListeners).start();
    }

    protected DockerComposeLifecycleManager createDockerComposeLifecycleManager(ConfigurableApplicationContext applicationContext, Binder binder, DockerComposeProperties properties, Set<ApplicationListener<?>> eventListeners) {
        return new DockerComposeLifecycleManager((ApplicationContext)applicationContext, this.shutdownHandlers, properties, eventListeners);
    }
}

