/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.redis;

import org.springframework.boot.autoconfigure.data.redis.RedisConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.ssl.SslBundle;

class RedisDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<RedisConnectionDetails> {
    private static final String[] REDIS_CONTAINER_NAMES = new String[]{"redis", "bitnami/redis", "bitnamilegacy/redis", "redis/redis-stack", "redis/redis-stack-server"};
    private static final int REDIS_PORT = 6379;

    RedisDockerComposeConnectionDetailsFactory() {
        super(REDIS_CONTAINER_NAMES, new String[0]);
    }

    @Override
    protected RedisConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new RedisDockerComposeConnectionDetails(source.getRunningService());
    }

    static class RedisDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements RedisConnectionDetails {
        private final RedisConnectionDetails.Standalone standalone;

        RedisDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.standalone = RedisConnectionDetails.Standalone.of((String)service.host(), (int)service.ports().get(6379), (SslBundle)this.getSslBundle(service));
        }

        public RedisConnectionDetails.Standalone getStandalone() {
            return this.standalone;
        }
    }
}

