/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.postgres;

import org.springframework.boot.autoconfigure.jdbc.JdbcConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.docker.compose.service.connection.jdbc.JdbcUrlBuilder;
import org.springframework.boot.docker.compose.service.connection.postgres.PostgresEnvironment;

class PostgresJdbcDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<JdbcConnectionDetails> {
    private static final String[] POSTGRES_CONTAINER_NAMES = new String[]{"postgres", "bitnami/postgresql", "bitnamilegacy/postgresql"};

    protected PostgresJdbcDockerComposeConnectionDetailsFactory() {
        super(POSTGRES_CONTAINER_NAMES, new String[0]);
    }

    @Override
    protected JdbcConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new PostgresJdbcDockerComposeConnectionDetails(source.getRunningService());
    }

    static class PostgresJdbcDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements JdbcConnectionDetails {
        private static final JdbcUrlBuilder jdbcUrlBuilder = new JdbcUrlBuilder("postgresql", 5432);
        private final PostgresEnvironment environment;
        private final String jdbcUrl;

        PostgresJdbcDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.environment = new PostgresEnvironment(service.env());
            this.jdbcUrl = jdbcUrlBuilder.build(service, this.environment.getDatabase());
        }

        public String getUsername() {
            return this.environment.getUsername();
        }

        public String getPassword() {
            return this.environment.getPassword();
        }

        public String getJdbcUrl() {
            return this.jdbcUrl;
        }
    }
}

