/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.rabbit;

import java.util.List;
import org.springframework.boot.autoconfigure.amqp.RabbitConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.docker.compose.service.connection.rabbit.RabbitEnvironment;

class RabbitDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<RabbitConnectionDetails> {
    private static final String[] RABBITMQ_CONTAINER_NAMES = new String[]{"rabbitmq", "bitnami/rabbitmq"};
    private static final int RABBITMQ_PORT = 5672;

    protected RabbitDockerComposeConnectionDetailsFactory() {
        super(RABBITMQ_CONTAINER_NAMES, new String[0]);
    }

    @Override
    protected RabbitConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new RabbitDockerComposeConnectionDetails(source.getRunningService());
    }

    static class RabbitDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements RabbitConnectionDetails {
        private final RabbitEnvironment environment;
        private final List<RabbitConnectionDetails.Address> addresses;

        protected RabbitDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.environment = new RabbitEnvironment(service.env());
            this.addresses = List.of(new RabbitConnectionDetails.Address(service.host(), service.ports().get(5672)));
        }

        public String getUsername() {
            return this.environment.getUsername();
        }

        public String getPassword() {
            return this.environment.getPassword();
        }

        public String getVirtualHost() {
            return "/";
        }

        public List<RabbitConnectionDetails.Address> getAddresses() {
            return this.addresses;
        }
    }
}

