/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.zipkin;

import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;

class ZipkinDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<ZipkinConnectionDetails> {
    private static final int ZIPKIN_PORT = 9411;

    ZipkinDockerComposeConnectionDetailsFactory() {
        super("openzipkin/zipkin", "org.springframework.boot.actuate.autoconfigure.tracing.zipkin.ZipkinAutoConfiguration");
    }

    @Override
    protected ZipkinConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new ZipkinDockerComposeConnectionDetails(source.getRunningService());
    }

    static class ZipkinDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements ZipkinConnectionDetails {
        private final String host;
        private final int port;

        ZipkinDockerComposeConnectionDetails(RunningService source) {
            super(source);
            this.host = source.host();
            this.port = source.ports().get(9411);
        }

        public String getSpanEndpoint() {
            return "http://" + this.host + ":" + this.port + "/api/v2/spans";
        }
    }
}

