/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.jdbc;

import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcUrlBuilder {
    private static final String PARAMETERS_LABEL = "org.springframework.boot.jdbc.parameters";
    private final String driverProtocol;
    private final int containerPort;

    public JdbcUrlBuilder(String driverProtocol, int containerPort) {
        Assert.notNull((Object)driverProtocol, (String)"DriverProtocol must not be null");
        this.driverProtocol = driverProtocol;
        this.containerPort = containerPort;
    }

    public String build(RunningService service) {
        return this.build(service, null);
    }

    public String build(RunningService service, String database) {
        return this.urlFor(service, database);
    }

    private String urlFor(RunningService service, String database) {
        Assert.notNull((Object)service, (String)"Service must not be null");
        String parameters = this.getParameters(service);
        StringBuilder url = new StringBuilder("jdbc:%s://%s:%d".formatted(this.driverProtocol, service.host(), service.ports().get(this.containerPort)));
        if (StringUtils.hasLength((String)database)) {
            url.append("/");
            url.append(database);
        }
        url.append(parameters);
        return url.toString();
    }

    private String getParameters(RunningService service) {
        String parameters = service.labels().get(PARAMETERS_LABEL);
        return StringUtils.hasLength((String)parameters) ? "?" + parameters : "";
    }
}

