/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection;

import java.util.function.Predicate;
import org.springframework.boot.docker.compose.core.ImageReference;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;

class ConnectionNamePredicate
implements Predicate<DockerComposeConnectionSource> {
    private final String required;

    ConnectionNamePredicate(String required) {
        this.required = this.asCanonicalName(required);
    }

    @Override
    public boolean test(DockerComposeConnectionSource source) {
        String actual = this.getActual(source.getRunningService());
        return this.required.equals(actual);
    }

    private String getActual(RunningService service) {
        String label = service.labels().get("org.springframework.boot.service-connection");
        return label != null ? this.asCanonicalName(label) : service.image().getName();
    }

    private String asCanonicalName(String name) {
        return ImageReference.of(name).getName();
    }
}

