/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart.classloader;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.devtools.restart.classloader.ClassLoaderFile;
import org.springframework.boot.devtools.restart.classloader.ClassLoaderFileRepository;
import org.springframework.util.Assert;

public class ClassLoaderFiles
implements ClassLoaderFileRepository,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, SourceDirectory> sourceDirectories;
    private final Map<String, ClassLoaderFile> filesByName;

    public ClassLoaderFiles() {
        this.sourceDirectories = new LinkedHashMap<String, SourceDirectory>();
        this.filesByName = new LinkedHashMap<String, ClassLoaderFile>();
    }

    public ClassLoaderFiles(ClassLoaderFiles classLoaderFiles) {
        Assert.notNull((Object)classLoaderFiles, (String)"'classLoaderFiles' must not be null");
        this.sourceDirectories = new LinkedHashMap<String, SourceDirectory>(classLoaderFiles.sourceDirectories);
        this.filesByName = new LinkedHashMap<String, ClassLoaderFile>(classLoaderFiles.filesByName);
    }

    public void addAll(ClassLoaderFiles files) {
        Assert.notNull((Object)files, (String)"'files' must not be null");
        for (SourceDirectory directory : files.getSourceDirectories()) {
            for (Map.Entry<String, ClassLoaderFile> entry : directory.getFilesEntrySet()) {
                this.addFile(directory.getName(), entry.getKey(), entry.getValue());
            }
        }
    }

    public void addFile(String name, ClassLoaderFile file) {
        this.addFile("", name, file);
    }

    public void addFile(String sourceDirectory, String name, ClassLoaderFile file) {
        Assert.notNull((Object)sourceDirectory, (String)"'sourceDirectory' must not be null");
        Assert.notNull((Object)name, (String)"'name' must not be null");
        Assert.notNull((Object)file, (String)"'file' must not be null");
        this.removeAll(name);
        this.getOrCreateSourceDirectory(sourceDirectory).add(name, file);
        this.filesByName.put(name, file);
    }

    private void removeAll(String name) {
        for (SourceDirectory sourceDirectory : this.sourceDirectories.values()) {
            sourceDirectory.remove(name);
        }
        this.filesByName.remove(name);
    }

    protected final SourceDirectory getOrCreateSourceDirectory(String name) {
        return this.sourceDirectories.computeIfAbsent(name, key -> new SourceDirectory(name));
    }

    public Collection<SourceDirectory> getSourceDirectories() {
        return Collections.unmodifiableCollection(this.sourceDirectories.values());
    }

    public int size() {
        return this.filesByName.size();
    }

    @Override
    public @Nullable ClassLoaderFile getFile(@Nullable String name) {
        return this.filesByName.get(name);
    }

    public Set<Map.Entry<String, ClassLoaderFile>> getFileEntries() {
        return Collections.unmodifiableSet(this.filesByName.entrySet());
    }

    public static class SourceDirectory
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final Map<String, ClassLoaderFile> files = new LinkedHashMap<String, ClassLoaderFile>();

        SourceDirectory(String name) {
            this.name = name;
        }

        public Set<Map.Entry<String, ClassLoaderFile>> getFilesEntrySet() {
            return this.files.entrySet();
        }

        protected final void add(String name, ClassLoaderFile file) {
            this.files.put(name, file);
        }

        protected final void remove(String name) {
            this.files.remove(name);
        }

        protected final @Nullable ClassLoaderFile get(String name) {
            return this.files.get(name);
        }

        public String getName() {
            return this.name;
        }

        public Collection<ClassLoaderFile> getFiles() {
            return Collections.unmodifiableCollection(this.files.values());
        }
    }
}

