/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.classpath;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.devtools.classpath.ClassPathRestartStrategy;
import org.springframework.boot.devtools.filewatch.ChangedFile;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;

public class PatternClassPathRestartStrategy
implements ClassPathRestartStrategy {
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final String[] excludePatterns;

    public PatternClassPathRestartStrategy(String[] excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    public PatternClassPathRestartStrategy(@Nullable String excludePatterns) {
        this(StringUtils.commaDelimitedListToStringArray((String)excludePatterns));
    }

    @Override
    public boolean isRestartRequired(ChangedFile file) {
        for (String pattern : this.excludePatterns) {
            if (!this.matcher.match(pattern, file.getRelativeName())) continue;
            return false;
        }
        return true;
    }
}

