/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.autoconfigure;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.devtools.autoconfigure.DevToolsProperties;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@ConditionalOnClass(value={SecurityFilterChain.class, HttpSecurity.class})
@Configuration(proxyBeanMethods=false)
class RemoteDevtoolsSecurityConfiguration {
    private final String url;

    RemoteDevtoolsSecurityConfiguration(DevToolsProperties devToolsProperties, ServerProperties serverProperties) {
        ServerProperties.Servlet servlet = serverProperties.getServlet();
        String servletContextPath = servlet.getContextPath() != null ? servlet.getContextPath() : "";
        this.url = servletContextPath + devToolsProperties.getRemote().getContextPath() + "/restart";
    }

    @Bean
    @Order(value=0x7FFFFFF9)
    SecurityFilterChain devtoolsSecurityFilterChain(HttpSecurity http) {
        http.securityMatcher((RequestMatcher)PathPatternRequestMatcher.withDefaults().matcher(this.url));
        http.authorizeHttpRequests(requests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.anyRequest()).anonymous());
        http.csrf(AbstractHttpConfigurer::disable);
        return (SecurityFilterChain)http.build();
    }
}

