/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.settings;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class DevToolsSettings {
    public static final String SETTINGS_RESOURCE_LOCATION = "META-INF/spring-devtools.properties";
    private static DevToolsSettings settings;
    private final List<Pattern> restartIncludePatterns = new ArrayList<Pattern>();
    private final List<Pattern> restartExcludePatterns = new ArrayList<Pattern>();

    DevToolsSettings() {
    }

    void add(Map<?, ?> properties) {
        Map<String, Pattern> includes = this.getPatterns(properties, "restart.include.");
        this.restartIncludePatterns.addAll(includes.values());
        Map<String, Pattern> excludes = this.getPatterns(properties, "restart.exclude.");
        this.restartExcludePatterns.addAll(excludes.values());
    }

    private Map<String, Pattern> getPatterns(Map<?, ?> properties, String prefix) {
        LinkedHashMap<String, Pattern> patterns = new LinkedHashMap<String, Pattern>();
        for (Map.Entry<?, ?> entry : properties.entrySet()) {
            String name = String.valueOf(entry.getKey());
            if (!name.startsWith(prefix)) continue;
            Pattern pattern = Pattern.compile((String)entry.getValue());
            patterns.put(name, pattern);
        }
        return patterns;
    }

    public boolean isRestartInclude(URL url) {
        return this.isMatch(url.toString(), this.restartIncludePatterns);
    }

    public boolean isRestartExclude(URL url) {
        return this.isMatch(url.toString(), this.restartExcludePatterns);
    }

    private boolean isMatch(String url, List<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(url).find()) continue;
            return true;
        }
        return false;
    }

    public static DevToolsSettings get() {
        if (settings == null) {
            settings = DevToolsSettings.load();
        }
        return settings;
    }

    static DevToolsSettings load() {
        return DevToolsSettings.load(SETTINGS_RESOURCE_LOCATION);
    }

    static DevToolsSettings load(String location) {
        try {
            DevToolsSettings settings = new DevToolsSettings();
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(location);
            while (urls.hasMoreElements()) {
                settings.add(PropertiesLoaderUtils.loadProperties((Resource)new UrlResource(urls.nextElement())));
            }
            return settings;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to load devtools settings from location [" + location + "]", ex);
        }
    }
}

