/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.dependency.tools;

import java.io.InputStream;
import java.util.Collection;
import org.springframework.boot.dependency.tools.AbstractDependencies;
import org.springframework.boot.dependency.tools.Assert;
import org.springframework.boot.dependency.tools.Dependencies;
import org.springframework.boot.dependency.tools.Dependency;
import org.springframework.boot.dependency.tools.PomDependencies;

class ManagedDependenciesDelegate
extends AbstractDependencies {
    private static Dependencies springBootDependencies;

    public ManagedDependenciesDelegate(Collection<Dependencies> versionManagedDependencies) {
        this(ManagedDependenciesDelegate.getSpringBootDependencies(), versionManagedDependencies);
    }

    ManagedDependenciesDelegate(Dependencies rootDependencies, Collection<Dependencies> versionManagedDependencies) {
        this.addAll(rootDependencies);
        if (versionManagedDependencies != null) {
            for (Dependencies managedDependencies : versionManagedDependencies) {
                this.addAll(managedDependencies);
            }
        }
    }

    private void addAll(Dependencies dependencies) {
        for (Dependency dependency : dependencies) {
            this.add(new AbstractDependencies.ArtifactAndGroupId(dependency), dependency);
        }
    }

    private static Dependencies getSpringBootDependencies() {
        if (springBootDependencies == null) {
            springBootDependencies = new PomDependencies(ManagedDependenciesDelegate.getResource("effective-pom.xml"));
        }
        return springBootDependencies;
    }

    private static InputStream getResource(String name) {
        InputStream inputStream = ManagedDependenciesDelegate.class.getResourceAsStream(name);
        Assert.notNull(inputStream, "Unable to load " + name);
        return inputStream;
    }
}

