/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.redis.testcontainers;

import com.redis.testcontainers.RedisContainer;
import com.redis.testcontainers.RedisStackContainer;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.data.redis.autoconfigure.DataRedisConnectionDetails;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.Container;

class RedisContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<Container<?>, DataRedisConnectionDetails> {
    private static final List<String> REDIS_IMAGE_NAMES = List.of("redis", "redis/redis-stack", "redis/redis-stack-server");
    private static final int REDIS_PORT = 6379;

    RedisContainerConnectionDetailsFactory() {
        super(REDIS_IMAGE_NAMES, new String[0]);
    }

    protected boolean sourceAccepts(ContainerConnectionSource<Container<?>> source, Class<?> requiredContainerType, Class<?> requiredConnectionDetailsType) {
        return super.sourceAccepts(source, requiredContainerType, requiredConnectionDetailsType) || source.accepts(ContainerConnectionDetailsFactory.ANY_CONNECTION_NAME, RedisContainer.class, requiredConnectionDetailsType) || source.accepts(ContainerConnectionDetailsFactory.ANY_CONNECTION_NAME, RedisStackContainer.class, requiredConnectionDetailsType);
    }

    protected DataRedisConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
        return new RedisContainerConnectionDetails(source);
    }

    private static final class RedisContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<Container<?>>
    implements DataRedisConnectionDetails {
        private RedisContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
            super(source);
        }

        @Override
        public @Nullable SslBundle getSslBundle() {
            return super.getSslBundle();
        }

        @Override
        public DataRedisConnectionDetails.Standalone getStandalone() {
            return DataRedisConnectionDetails.Standalone.of(this.getContainer().getHost(), this.getContainer().getMappedPort(6379));
        }
    }
}

