/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.redis.autoconfigure.health;

import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.data.redis.autoconfigure.RedisAutoConfiguration;
import org.springframework.boot.data.redis.autoconfigure.health.RedisReactiveHealthContributorAutoConfiguration;
import org.springframework.boot.data.redis.health.RedisHealthIndicator;
import org.springframework.boot.health.autoconfigure.contributor.CompositeHealthContributorConfiguration;
import org.springframework.boot.health.autoconfigure.contributor.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.boot.health.contributor.HealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@AutoConfiguration(after={RedisAutoConfiguration.class, RedisReactiveHealthContributorAutoConfiguration.class})
@ConditionalOnClass(value={RedisConnectionFactory.class, HealthIndicator.class, ConditionalOnEnabledHealthIndicator.class})
@ConditionalOnBean(value={RedisConnectionFactory.class})
@ConditionalOnEnabledHealthIndicator(value="redis")
public final class RedisHealthContributorAutoConfiguration
extends CompositeHealthContributorConfiguration<RedisHealthIndicator, RedisConnectionFactory> {
    RedisHealthContributorAutoConfiguration() {
        super(RedisHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"redisHealthIndicator", "redisHealthContributor"})
    HealthContributor redisHealthContributor(ConfigurableListableBeanFactory beanFactory) {
        return (HealthContributor)this.createContributor(beanFactory, RedisConnectionFactory.class);
    }
}

