/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.mongodb.autoconfigure.health;

import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.data.mongodb.autoconfigure.MongoDataAutoConfiguration;
import org.springframework.boot.data.mongodb.autoconfigure.health.MongoReactiveHealthContributorAutoConfiguration;
import org.springframework.boot.data.mongodb.health.MongoHealthIndicator;
import org.springframework.boot.health.autoconfigure.contributor.CompositeHealthContributorConfiguration;
import org.springframework.boot.health.autoconfigure.contributor.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.boot.mongodb.autoconfigure.MongoAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.data.mongodb.core.MongoTemplate;

@AutoConfiguration(after={MongoReactiveHealthContributorAutoConfiguration.class, MongoDataAutoConfiguration.class, MongoAutoConfiguration.class})
@ConditionalOnClass(value={MongoTemplate.class, MongoHealthIndicator.class, ConditionalOnEnabledHealthIndicator.class})
@ConditionalOnBean(value={MongoTemplate.class})
@ConditionalOnEnabledHealthIndicator(value="mongo")
public final class MongoHealthContributorAutoConfiguration
extends CompositeHealthContributorConfiguration<MongoHealthIndicator, MongoTemplate> {
    MongoHealthContributorAutoConfiguration() {
        super(MongoHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"mongoHealthIndicator", "mongoHealthContributor"})
    HealthContributor mongoHealthContributor(ConfigurableListableBeanFactory beanFactory) {
        return (HealthContributor)this.createContributor(beanFactory, MongoTemplate.class);
    }
}

