/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.jdbc.autoconfigure;

import java.util.function.Function;
import org.springframework.data.jdbc.core.dialect.DialectResolver;
import org.springframework.data.jdbc.core.dialect.JdbcDb2Dialect;
import org.springframework.data.jdbc.core.dialect.JdbcDialect;
import org.springframework.data.jdbc.core.dialect.JdbcH2Dialect;
import org.springframework.data.jdbc.core.dialect.JdbcHsqlDbDialect;
import org.springframework.data.jdbc.core.dialect.JdbcMariaDbDialect;
import org.springframework.data.jdbc.core.dialect.JdbcMySqlDialect;
import org.springframework.data.jdbc.core.dialect.JdbcOracleDialect;
import org.springframework.data.jdbc.core.dialect.JdbcPostgresDialect;
import org.springframework.data.jdbc.core.dialect.JdbcSqlServerDialect;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.util.Assert;

public enum DataJdbcDatabaseDialect {
    DB2((Dialect)JdbcDb2Dialect.INSTANCE),
    H2((Dialect)JdbcH2Dialect.INSTANCE),
    HSQL((Dialect)JdbcHsqlDbDialect.INSTANCE),
    MARIA(JdbcMariaDbDialect.class),
    MYSQL(JdbcMySqlDialect.class),
    ORACLE((Dialect)JdbcOracleDialect.INSTANCE),
    POSTGRESQL((Dialect)JdbcPostgresDialect.INSTANCE),
    SQL_SERVER((Dialect)JdbcSqlServerDialect.INSTANCE);

    private final Function<JdbcOperations, Dialect> dialectResolver;

    private DataJdbcDatabaseDialect(Class<? extends Dialect> dialectType) {
        this.dialectResolver = jdbc -> {
            JdbcDialect dialect = DialectResolver.getDialect((JdbcOperations)jdbc);
            Assert.isInstanceOf((Class)dialectType, (Object)dialect);
            return dialect;
        };
    }

    private DataJdbcDatabaseDialect(Dialect dialect) {
        this.dialectResolver = jdbc -> dialect;
    }

    Dialect getDialect(JdbcOperations jdbc) {
        return this.dialectResolver.apply(jdbc);
    }
}

