/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.elasticsearch.autoconfigure;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import java.util.Collections;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScanner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchClient;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchCustomConversions;
import org.springframework.data.elasticsearch.core.convert.MappingElasticsearchConverter;
import org.springframework.data.elasticsearch.core.mapping.SimpleElasticsearchMappingContext;
import org.springframework.data.mapping.context.MappingContext;

abstract class ElasticsearchDataConfiguration {
    ElasticsearchDataConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    static class ReactiveRestClientConfiguration {
        ReactiveRestClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ReactiveElasticsearchOperations.class}, name={"reactiveElasticsearchTemplate"})
        @ConditionalOnBean(value={ReactiveElasticsearchClient.class})
        ReactiveElasticsearchTemplate reactiveElasticsearchTemplate(ReactiveElasticsearchClient client, ElasticsearchConverter converter) {
            return new ReactiveElasticsearchTemplate(client, converter);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ElasticsearchClient.class})
    static class JavaClientConfiguration {
        JavaClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ElasticsearchOperations.class}, name={"elasticsearchTemplate"})
        @ConditionalOnBean(value={ElasticsearchClient.class})
        ElasticsearchTemplate elasticsearchTemplate(ElasticsearchClient client, ElasticsearchConverter converter) {
            return new ElasticsearchTemplate(client, converter);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class BaseConfiguration {
        BaseConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ElasticsearchCustomConversions elasticsearchCustomConversions() {
            return new ElasticsearchCustomConversions(Collections.emptyList());
        }

        @Bean
        @ConditionalOnMissingBean
        SimpleElasticsearchMappingContext elasticsearchMappingContext(ApplicationContext applicationContext, ElasticsearchCustomConversions elasticsearchCustomConversions) throws ClassNotFoundException {
            SimpleElasticsearchMappingContext mappingContext = new SimpleElasticsearchMappingContext();
            mappingContext.setInitialEntitySet(new EntityScanner(applicationContext).scan(new Class[]{Document.class}));
            mappingContext.setSimpleTypeHolder(elasticsearchCustomConversions.getSimpleTypeHolder());
            return mappingContext;
        }

        @Bean
        @ConditionalOnMissingBean
        ElasticsearchConverter elasticsearchConverter(SimpleElasticsearchMappingContext mappingContext, ElasticsearchCustomConversions elasticsearchCustomConversions) {
            MappingElasticsearchConverter converter = new MappingElasticsearchConverter((MappingContext)mappingContext);
            converter.setConversions((CustomConversions)elasticsearchCustomConversions);
            return converter;
        }
    }
}

