/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.couchbase.autoconfigure;

import java.util.Collections;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.data.couchbase.autoconfigure.DataCouchbaseProperties;
import org.springframework.boot.persistence.autoconfigure.EntityScanner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.couchbase.core.convert.CouchbaseCustomConversions;
import org.springframework.data.couchbase.core.convert.MappingCouchbaseConverter;
import org.springframework.data.couchbase.core.convert.translation.JacksonTranslationService;
import org.springframework.data.couchbase.core.convert.translation.TranslationService;
import org.springframework.data.couchbase.core.mapping.CouchbaseMappingContext;
import org.springframework.data.couchbase.core.mapping.Document;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.FieldNamingStrategy;

@Configuration(proxyBeanMethods=false)
class DataCouchbaseConfiguration {
    DataCouchbaseConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    MappingCouchbaseConverter couchbaseMappingConverter(DataCouchbaseProperties properties, CouchbaseMappingContext couchbaseMappingContext, CouchbaseCustomConversions couchbaseCustomConversions) {
        MappingCouchbaseConverter converter = new MappingCouchbaseConverter((MappingContext)couchbaseMappingContext, properties.getTypeKey());
        converter.setCustomConversions((CustomConversions)couchbaseCustomConversions);
        return converter;
    }

    @Bean
    @ConditionalOnMissingBean
    TranslationService couchbaseTranslationService() {
        return new JacksonTranslationService();
    }

    @Bean(name={"couchbaseMappingContext"})
    @ConditionalOnMissingBean(name={"couchbaseMappingContext"})
    CouchbaseMappingContext couchbaseMappingContext(DataCouchbaseProperties properties, ApplicationContext applicationContext, CouchbaseCustomConversions couchbaseCustomConversions) throws ClassNotFoundException {
        CouchbaseMappingContext mappingContext = new CouchbaseMappingContext();
        mappingContext.setInitialEntitySet(new EntityScanner(applicationContext).scan(new Class[]{Document.class}));
        mappingContext.setSimpleTypeHolder(couchbaseCustomConversions.getSimpleTypeHolder());
        Class<?> fieldNamingStrategy = properties.getFieldNamingStrategy();
        if (fieldNamingStrategy != null) {
            mappingContext.setFieldNamingStrategy((FieldNamingStrategy)BeanUtils.instantiateClass(fieldNamingStrategy));
        }
        mappingContext.setAutoIndexCreation(properties.isAutoIndex());
        return mappingContext;
    }

    @Bean(name={"couchbaseCustomConversions"})
    @ConditionalOnMissingBean(name={"couchbaseCustomConversions"})
    CouchbaseCustomConversions couchbaseCustomConversions() {
        return new CouchbaseCustomConversions(Collections.emptyList());
    }
}

