/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.couchbase.autoconfigure.health;

import com.couchbase.client.java.Cluster;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.couchbase.autoconfigure.CouchbaseAutoConfiguration;
import org.springframework.boot.couchbase.health.CouchbaseReactiveHealthIndicator;
import org.springframework.boot.health.autoconfigure.contributor.CompositeReactiveHealthContributorConfiguration;
import org.springframework.boot.health.autoconfigure.contributor.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.health.contributor.ReactiveHealthContributor;
import org.springframework.context.annotation.Bean;
import reactor.core.publisher.Flux;

@AutoConfiguration(after={CouchbaseAutoConfiguration.class})
@ConditionalOnClass(value={Cluster.class, Flux.class, CouchbaseReactiveHealthIndicator.class, ConditionalOnEnabledHealthIndicator.class})
@ConditionalOnBean(value={Cluster.class})
@ConditionalOnEnabledHealthIndicator(value="couchbase")
public class CouchbaseReactiveHealthContributorAutoConfiguration
extends CompositeReactiveHealthContributorConfiguration<CouchbaseReactiveHealthIndicator, Cluster> {
    public CouchbaseReactiveHealthContributorAutoConfiguration() {
        super(CouchbaseReactiveHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"couchbaseHealthIndicator", "couchbaseHealthContributor"})
    public ReactiveHealthContributor couchbaseHealthContributor(ConfigurableListableBeanFactory beanFactory) {
        return (ReactiveHealthContributor)this.createContributor(beanFactory, Cluster.class);
    }
}

