/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cloudfoundry.autoconfigure.actuate.endpoint.servlet;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.cloudfoundry.autoconfigure.actuate.endpoint.AccessLevel;
import org.springframework.boot.cloudfoundry.autoconfigure.actuate.endpoint.CloudFoundryAuthorizationException;
import org.springframework.boot.cloudfoundry.autoconfigure.actuate.endpoint.SecurityResponse;
import org.springframework.boot.cloudfoundry.autoconfigure.actuate.endpoint.Token;
import org.springframework.boot.cloudfoundry.autoconfigure.actuate.endpoint.servlet.SecurityService;
import org.springframework.boot.cloudfoundry.autoconfigure.actuate.endpoint.servlet.TokenValidator;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsUtils;

class SecurityInterceptor {
    private static final Log logger = LogFactory.getLog(SecurityInterceptor.class);
    private final @Nullable TokenValidator tokenValidator;
    private final @Nullable SecurityService cloudFoundrySecurityService;
    private final @Nullable String applicationId;
    private static final SecurityResponse SUCCESS = SecurityResponse.success();

    SecurityInterceptor(@Nullable TokenValidator tokenValidator, @Nullable SecurityService cloudFoundrySecurityService, @Nullable String applicationId) {
        this.tokenValidator = tokenValidator;
        this.cloudFoundrySecurityService = cloudFoundrySecurityService;
        this.applicationId = applicationId;
    }

    SecurityResponse preHandle(HttpServletRequest request, @Nullable EndpointId endpointId) {
        if (CorsUtils.isPreFlightRequest((HttpServletRequest)request)) {
            return SecurityResponse.success();
        }
        try {
            if (!StringUtils.hasText((String)this.applicationId)) {
                throw new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.SERVICE_UNAVAILABLE, "Application id is not available");
            }
            if (this.cloudFoundrySecurityService == null || this.tokenValidator == null) {
                throw new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.SERVICE_UNAVAILABLE, "Cloud controller URL is not available");
            }
            if (HttpMethod.OPTIONS.matches(request.getMethod())) {
                return SUCCESS;
            }
            this.check(request, endpointId);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            if (ex instanceof CloudFoundryAuthorizationException) {
                CloudFoundryAuthorizationException cfException = (CloudFoundryAuthorizationException)ex;
                return new SecurityResponse(cfException.getStatusCode(), "{\"security_error\":\"" + cfException.getMessage() + "\"}");
            }
            return new SecurityResponse(HttpStatus.INTERNAL_SERVER_ERROR, ex.getMessage());
        }
        return SecurityResponse.success();
    }

    private void check(HttpServletRequest request, @Nullable EndpointId endpointId) {
        Assert.state((this.cloudFoundrySecurityService != null ? 1 : 0) != 0, (String)"'cloudFoundrySecurityService' must not be null");
        Assert.state((this.applicationId != null ? 1 : 0) != 0, (String)"'applicationId' must not be null");
        Assert.state((this.tokenValidator != null ? 1 : 0) != 0, (String)"'tokenValidator' must not be null");
        Token token = this.getToken(request);
        this.tokenValidator.validate(token);
        AccessLevel accessLevel = this.cloudFoundrySecurityService.getAccessLevel(token.toString(), this.applicationId);
        if (!accessLevel.isAccessAllowed(endpointId != null ? endpointId.toLowerCaseString() : "")) {
            throw new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.ACCESS_DENIED, "Access denied");
        }
        request.setAttribute("cloudFoundryAccessLevel", (Object)accessLevel);
    }

    private Token getToken(HttpServletRequest request) {
        String authorization = request.getHeader("Authorization");
        String bearerPrefix = "bearer ";
        if (authorization == null || !authorization.toLowerCase(Locale.ENGLISH).startsWith(bearerPrefix)) {
            throw new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.MISSING_AUTHORIZATION, "Authorization header is missing or invalid");
        }
        return new Token(authorization.substring(bearerPrefix.length()));
    }
}

