/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.init;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.net.URIBuilder;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.cli.command.init.InitializrServiceMetadata;
import org.springframework.boot.cli.command.init.ProjectType;
import org.springframework.boot.cli.command.init.ReportableException;
import org.springframework.util.StringUtils;

class ProjectGenerationRequest {
    public static final String DEFAULT_SERVICE_URL = "https://start.spring.io";
    private String serviceUrl = "https://start.spring.io";
    private @Nullable String output;
    private boolean extract;
    private @Nullable String groupId;
    private @Nullable String artifactId;
    private @Nullable String version;
    private @Nullable String name;
    private @Nullable String description;
    private @Nullable String packageName;
    private @Nullable String type;
    private @Nullable String packaging;
    private @Nullable String build;
    private @Nullable String format;
    private boolean detectType;
    private @Nullable String javaVersion;
    private @Nullable String language;
    private @Nullable String bootVersion;
    private final List<String> dependencies = new ArrayList<String>();

    ProjectGenerationRequest() {
    }

    String getServiceUrl() {
        return this.serviceUrl;
    }

    void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    @Nullable String getOutput() {
        return this.output;
    }

    void setOutput(@Nullable String output) {
        if (output != null && output.endsWith("/")) {
            this.output = output.substring(0, output.length() - 1);
            this.extract = true;
        } else {
            this.output = output;
        }
    }

    boolean isExtract() {
        return this.extract;
    }

    void setExtract(boolean extract) {
        this.extract = extract;
    }

    @Nullable String getGroupId() {
        return this.groupId;
    }

    void setGroupId(@Nullable String groupId) {
        this.groupId = groupId;
    }

    @Nullable String getArtifactId() {
        return this.artifactId;
    }

    void setArtifactId(@Nullable String artifactId) {
        this.artifactId = artifactId;
    }

    @Nullable String getVersion() {
        return this.version;
    }

    void setVersion(@Nullable String version) {
        this.version = version;
    }

    @Nullable String getName() {
        return this.name;
    }

    void setName(@Nullable String name) {
        this.name = name;
    }

    @Nullable String getDescription() {
        return this.description;
    }

    void setDescription(@Nullable String description) {
        this.description = description;
    }

    @Nullable String getPackageName() {
        return this.packageName;
    }

    void setPackageName(@Nullable String packageName) {
        this.packageName = packageName;
    }

    @Nullable String getType() {
        return this.type;
    }

    void setType(@Nullable String type) {
        this.type = type;
    }

    @Nullable String getPackaging() {
        return this.packaging;
    }

    void setPackaging(@Nullable String packaging) {
        this.packaging = packaging;
    }

    @Nullable String getBuild() {
        return this.build;
    }

    void setBuild(@Nullable String build) {
        this.build = build;
    }

    @Nullable String getFormat() {
        return this.format;
    }

    void setFormat(@Nullable String format) {
        this.format = format;
    }

    boolean isDetectType() {
        return this.detectType;
    }

    void setDetectType(boolean detectType) {
        this.detectType = detectType;
    }

    @Nullable String getJavaVersion() {
        return this.javaVersion;
    }

    void setJavaVersion(@Nullable String javaVersion) {
        this.javaVersion = javaVersion;
    }

    @Nullable String getLanguage() {
        return this.language;
    }

    void setLanguage(@Nullable String language) {
        this.language = language;
    }

    @Nullable String getBootVersion() {
        return this.bootVersion;
    }

    void setBootVersion(@Nullable String bootVersion) {
        this.bootVersion = bootVersion;
    }

    List<String> getDependencies() {
        return this.dependencies;
    }

    URI generateUrl(InitializrServiceMetadata metadata) {
        try {
            String resolvedArtifactId;
            URIBuilder builder = new URIBuilder(this.serviceUrl);
            StringBuilder sb = new StringBuilder();
            if (builder.getPath() != null) {
                sb.append(builder.getPath());
            }
            ProjectType projectType = this.determineProjectType(metadata);
            this.type = projectType.getId();
            sb.append(projectType.getAction());
            builder.setPath(sb.toString());
            if (!this.dependencies.isEmpty()) {
                builder.setParameter("dependencies", StringUtils.collectionToCommaDelimitedString(this.dependencies));
            }
            if (this.groupId != null) {
                builder.setParameter("groupId", this.groupId);
            }
            if ((resolvedArtifactId = this.resolveArtifactId()) != null) {
                builder.setParameter("artifactId", resolvedArtifactId);
            }
            if (this.version != null) {
                builder.setParameter("version", this.version);
            }
            if (this.name != null) {
                builder.setParameter("name", this.name);
            }
            if (this.description != null) {
                builder.setParameter("description", this.description);
            }
            if (this.packageName != null) {
                builder.setParameter("packageName", this.packageName);
            }
            if (this.type != null) {
                builder.setParameter("type", projectType.getId());
            }
            if (this.packaging != null) {
                builder.setParameter("packaging", this.packaging);
            }
            if (this.javaVersion != null) {
                builder.setParameter("javaVersion", this.javaVersion);
            }
            if (this.language != null) {
                builder.setParameter("language", this.language);
            }
            if (this.bootVersion != null) {
                builder.setParameter("bootVersion", this.bootVersion);
            }
            return builder.build();
        }
        catch (URISyntaxException ex) {
            throw new ReportableException("Invalid service URL (" + ex.getMessage() + ")");
        }
    }

    protected ProjectType determineProjectType(InitializrServiceMetadata metadata) {
        if (this.type != null) {
            ProjectType result = metadata.getProjectTypes().get(this.type);
            if (result == null) {
                throw new ReportableException("No project type with id '" + this.type + "' - check the service capabilities (--list)");
            }
            return result;
        }
        if (this.isDetectType()) {
            HashMap<String, ProjectType> types = new HashMap<String, ProjectType>(metadata.getProjectTypes());
            if (this.build != null) {
                ProjectGenerationRequest.filter(types, "build", this.build);
            }
            if (this.format != null) {
                ProjectGenerationRequest.filter(types, "format", this.format);
            }
            if (types.size() == 1) {
                return (ProjectType)types.values().iterator().next();
            }
            if (types.isEmpty()) {
                throw new ReportableException("No type found with build '" + this.build + "' and format '" + this.format + "' check the service capabilities (--list)");
            }
            throw new ReportableException("Multiple types found with build '" + this.build + "' and format '" + this.format + "' use --type with a more specific value " + String.valueOf(types.keySet()));
        }
        ProjectType defaultType = metadata.getDefaultType();
        if (defaultType == null) {
            throw new ReportableException("No project type is set and no default is defined. Check the service capabilities (--list)");
        }
        return defaultType;
    }

    protected @Nullable String resolveArtifactId() {
        if (this.artifactId != null) {
            return this.artifactId;
        }
        if (this.output != null) {
            int i = this.output.lastIndexOf(46);
            return i != -1 ? this.output.substring(0, i) : this.output;
        }
        return null;
    }

    private static void filter(Map<String, ProjectType> projects, String tag, String tagValue) {
        projects.entrySet().removeIf(entry -> !tagValue.equals(((ProjectType)entry.getValue()).getTags().get(tag)));
    }
}

