/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.dependencies;

import org.springframework.boot.cli.compiler.dependencies.ArtifactCoordinatesResolver;
import org.springframework.boot.dependency.tools.Dependency;
import org.springframework.boot.dependency.tools.ManagedDependencies;
import org.springframework.util.StringUtils;

public class ManagedDependenciesArtifactCoordinatesResolver
implements ArtifactCoordinatesResolver {
    private final ManagedDependencies dependencies;

    public ManagedDependenciesArtifactCoordinatesResolver() {
        this(ManagedDependencies.get());
    }

    public ManagedDependenciesArtifactCoordinatesResolver(ManagedDependencies dependencies) {
        this.dependencies = dependencies;
    }

    @Override
    public String getGroupId(String artifactId) {
        Dependency dependency = this.find(artifactId);
        return dependency == null ? null : dependency.getGroupId();
    }

    @Override
    public String getVersion(String artifactId) {
        Dependency dependency = this.find(artifactId);
        return dependency == null ? null : dependency.getVersion();
    }

    @Override
    public String getArtifactId(String artifactId) {
        Dependency dependency = this.find(artifactId);
        return dependency == null ? null : dependency.getArtifactId();
    }

    private Dependency find(String artifactId) {
        if (StringUtils.countOccurrencesOf((String)artifactId, (String)":") == 2) {
            String[] tokens = artifactId.split(":");
            return new Dependency(tokens[0], tokens[1], tokens[2]);
        }
        if (artifactId != null) {
            if (artifactId.startsWith("spring-boot")) {
                return new Dependency("org.springframework.boot", artifactId, this.dependencies.getSpringBootVersion());
            }
            return this.dependencies.find(artifactId);
        }
        return null;
    }
}

