/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.batch.autoconfigure;

import org.jspecify.annotations.Nullable;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.support.DefaultBatchConfiguration;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.batch.autoconfigure.BatchProperties;
import org.springframework.boot.batch.autoconfigure.BatchTaskExecutor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;

@AutoConfiguration
@ConditionalOnClass(value={JobOperator.class})
@ConditionalOnMissingBean(value={DefaultBatchConfiguration.class}, annotation={EnableBatchProcessing.class})
@EnableConfigurationProperties(value={BatchProperties.class})
public final class BatchAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    static class SpringBootBatchDefaultConfiguration
    extends DefaultBatchConfiguration {
        private final @Nullable TaskExecutor taskExecutor;
        private final @Nullable JobParametersConverter jobParametersConverter;

        SpringBootBatchDefaultConfiguration(@BatchTaskExecutor ObjectProvider<TaskExecutor> batchTaskExecutor, ObjectProvider<JobParametersConverter> jobParametersConverter) {
            this.taskExecutor = (TaskExecutor)batchTaskExecutor.getIfAvailable();
            this.jobParametersConverter = (JobParametersConverter)jobParametersConverter.getIfAvailable();
        }

        @Deprecated(since="4.0.0", forRemoval=true)
        protected JobParametersConverter getJobParametersConverter() {
            return this.jobParametersConverter != null ? this.jobParametersConverter : super.getJobParametersConverter();
        }

        protected TaskExecutor getTaskExecutor() {
            return this.taskExecutor != null ? this.taskExecutor : super.getTaskExecutor();
        }
    }
}

