/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive.function.client;

import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.http.client.reactive.ClientHttpConnectorBuilderCustomizer;
import org.springframework.boot.autoconfigure.reactor.netty.ReactorNettyConfigurations;
import org.springframework.boot.autoconfigure.web.reactive.function.client.ReactorNettyHttpClientMapper;
import org.springframework.boot.http.client.reactive.ReactorClientHttpConnectorBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.http.client.ReactorResourceFactory;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;

@AutoConfiguration
@ConditionalOnClass(value={WebClient.class})
@Deprecated(since="3.5.0", forRemoval=true)
public class ClientHttpConnectorAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpClient.class})
    @Import(value={ReactorNettyConfigurations.ReactorResourceFactoryConfiguration.class})
    static class ReactorNetty {
        ReactorNetty() {
        }

        @Bean
        @Order(value=0)
        ClientHttpConnectorBuilderCustomizer<ReactorClientHttpConnectorBuilder> reactorNettyHttpClientMapperClientHttpConnectorBuilderCustomizer(ReactorResourceFactory reactorResourceFactory, ObjectProvider<ReactorNettyHttpClientMapper> mapperProvider) {
            return this.applyMappers(mapperProvider.orderedStream().toList());
        }

        private ClientHttpConnectorBuilderCustomizer<ReactorClientHttpConnectorBuilder> applyMappers(List<ReactorNettyHttpClientMapper> mappers) {
            return builder -> {
                for (ReactorNettyHttpClientMapper mapper : mappers) {
                    builder = builder.withHttpClientCustomizer(mapper::configure);
                }
                return builder;
            };
        }
    }
}

