/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded;

import org.eclipse.jetty.util.VirtualThreads;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.VirtualThreadPool;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.embedded.jetty.ConfigurableJettyWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class JettyVirtualThreadsWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableJettyWebServerFactory>,
Ordered {
    private final ServerProperties serverProperties;

    @Deprecated(since="3.5.11", forRemoval=true)
    public JettyVirtualThreadsWebServerFactoryCustomizer() {
        this(null);
    }

    public JettyVirtualThreadsWebServerFactoryCustomizer(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void customize(ConfigurableJettyWebServerFactory factory) {
        Assert.state((boolean)VirtualThreads.areSupported(), (String)"Virtual threads are not supported");
        VirtualThreadPool virtualThreadPool = new VirtualThreadPool();
        virtualThreadPool.setName("jetty-");
        if (this.serverProperties != null) {
            ServerProperties.Jetty.Threads properties = this.serverProperties.getJetty().getThreads();
            int maxThreadCount = properties.getMax() > 0 ? properties.getMax() : 200;
            virtualThreadPool.setMaxThreads(maxThreadCount);
        }
        factory.setThreadPool((ThreadPool)virtualThreadPool);
    }

    public int getOrder() {
        return 1;
    }
}

