/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.quartz;

import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.quartz.QuartzProperties;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.boot.jdbc.init.DataSourceScriptDatabaseInitializer;
import org.springframework.boot.jdbc.init.PlatformPlaceholderDatabaseDriverResolver;
import org.springframework.boot.sql.init.DatabaseInitializationSettings;

public class QuartzDataSourceScriptDatabaseInitializer
extends DataSourceScriptDatabaseInitializer {
    public QuartzDataSourceScriptDatabaseInitializer(DataSource dataSource, QuartzProperties properties) {
        this(dataSource, QuartzDataSourceScriptDatabaseInitializer.getSettings(dataSource, properties));
    }

    public QuartzDataSourceScriptDatabaseInitializer(DataSource dataSource, DatabaseInitializationSettings settings) {
        super(dataSource, settings);
    }

    public static DatabaseInitializationSettings getSettings(DataSource dataSource, QuartzProperties properties) {
        DatabaseInitializationSettings settings = new DatabaseInitializationSettings();
        PlatformPlaceholderDatabaseDriverResolver platformResolver = new PlatformPlaceholderDatabaseDriverResolver();
        platformResolver = platformResolver.withDriverPlatform(DatabaseDriver.DB2, "db2_v95");
        platformResolver = platformResolver.withDriverPlatform(DatabaseDriver.MYSQL, "mysql_innodb");
        platformResolver = platformResolver.withDriverPlatform(DatabaseDriver.MYSQL, "mysql_innodb");
        platformResolver = platformResolver.withDriverPlatform(DatabaseDriver.POSTGRESQL, "postgres");
        platformResolver = platformResolver.withDriverPlatform(DatabaseDriver.SQLSERVER, "sqlServer");
        settings.setSchemaLocations(platformResolver.resolveAll(dataSource, new String[]{properties.getJdbc().getSchema()}));
        settings.setMode(properties.getJdbc().getInitializeSchema());
        settings.setContinueOnError(true);
        return settings;
    }
}

