/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mobile;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.mobile.DeviceResolverAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mobile.device.site.SitePreferenceHandlerInterceptor;
import org.springframework.mobile.device.site.SitePreferenceHandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnClass(value={SitePreferenceHandlerInterceptor.class, SitePreferenceHandlerMethodArgumentResolver.class})
@AutoConfigureAfter(value={DeviceResolverAutoConfiguration.class})
@ConditionalOnProperty(prefix="spring.mobile.sitepreference", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class SitePreferenceAutoConfiguration {

    @Configuration
    @ConditionalOnWebApplication
    protected static class SitePreferenceMvcConfiguration
    extends WebMvcConfigurerAdapter {
        @Autowired
        private SitePreferenceHandlerInterceptor sitePreferenceHandlerInterceptor;

        protected SitePreferenceMvcConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={SitePreferenceHandlerInterceptor.class})
        public SitePreferenceHandlerInterceptor sitePreferenceHandlerInterceptor() {
            return new SitePreferenceHandlerInterceptor();
        }

        @Bean
        public SitePreferenceHandlerMethodArgumentResolver sitePreferenceHandlerMethodArgumentResolver() {
            return new SitePreferenceHandlerMethodArgumentResolver();
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)this.sitePreferenceHandlerInterceptor);
        }

        public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
            argumentResolvers.add((HandlerMethodArgumentResolver)this.sitePreferenceHandlerMethodArgumentResolver());
        }
    }
}

