/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms.hornetq;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.remoting.impl.invm.InVMAcceptorFactory;
import org.hornetq.core.server.JournalType;
import org.springframework.boot.autoconfigure.jms.hornetq.HornetQProperties;

class HornetQEmbeddedConfigurationFactory {
    private Log logger = LogFactory.getLog(HornetQEmbeddedConfigurationFactory.class);
    private final HornetQProperties.Embedded properties;

    HornetQEmbeddedConfigurationFactory(HornetQProperties properties) {
        this.properties = properties.getEmbedded();
    }

    public Configuration createConfiguration() {
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.setSecurityEnabled(false);
        configuration.setPersistenceEnabled(this.properties.isPersistent());
        String dataDir = this.getDataDir();
        configuration.setJournalDirectory(dataDir + "/journal");
        if (this.properties.isPersistent()) {
            configuration.setJournalType(JournalType.NIO);
            configuration.setLargeMessagesDirectory(dataDir + "/largemessages");
            configuration.setBindingsDirectory(dataDir + "/bindings");
            configuration.setPagingDirectory(dataDir + "/paging");
        }
        TransportConfiguration transportConfiguration = new TransportConfiguration(InVMAcceptorFactory.class.getName(), this.properties.generateTransportParameters());
        configuration.getAcceptorConfigurations().add(transportConfiguration);
        if (this.properties.isDefaultClusterPassword()) {
            this.logger.debug((Object)("Using default HornetQ cluster password: " + this.properties.getClusterPassword()));
        }
        configuration.setClusterPassword(this.properties.getClusterPassword());
        return configuration;
    }

    private String getDataDir() {
        if (this.properties.getDataDirectory() != null) {
            return this.properties.getDataDirectory();
        }
        String tempDirectory = System.getProperty("java.io.tmpdir");
        return new File(tempDirectory, "hornetq-data").getAbsolutePath();
    }
}

