/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jta.JtaAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.JpaBaseConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.orm.jpa.hibernate.SpringJtaPlatform;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.jndi.JndiLocatorDelegate;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class, EnableTransactionManagement.class, EntityManager.class})
@Conditional(value={HibernateEntityManagerCondition.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, JtaAutoConfiguration.class})
public class HibernateJpaAutoConfiguration
extends JpaBaseConfiguration {
    private static final Log logger = LogFactory.getLog(HibernateJpaAutoConfiguration.class);
    private static final String JTA_PLATFORM = "hibernate.transaction.jta.platform";
    private static final String[] NO_JTA_PLATFORM_CLASSES = new String[]{"org.hibernate.engine.transaction.jta.platform.internal.NoJtaPlatform", "org.hibernate.service.jta.platform.internal.NoJtaPlatform"};
    private static final String[] WEBSHERE_JTA_PLATFORM_CLASSES = new String[]{"org.hibernate.engine.transaction.jta.platform.internal.WebSphereExtendedJtaPlatform", "org.hibernate.service.jta.platform.internal.WebSphereExtendedJtaPlatform"};
    @Autowired
    private JpaProperties properties;
    @Autowired
    private DataSource dataSource;

    @Override
    protected AbstractJpaVendorAdapter createJpaVendorAdapter() {
        return new HibernateJpaVendorAdapter();
    }

    @Override
    protected Map<String, Object> getVendorProperties() {
        LinkedHashMap<String, Object> vendorProperties = new LinkedHashMap<String, Object>();
        vendorProperties.putAll(this.properties.getHibernateProperties(this.dataSource));
        return vendorProperties;
    }

    @Override
    protected void customizeVendorProperties(Map<String, Object> vendorProperties) {
        super.customizeVendorProperties(vendorProperties);
        if (!vendorProperties.containsKey(JTA_PLATFORM)) {
            this.configureJtaPlatform(vendorProperties);
        }
    }

    private void configureJtaPlatform(Map<String, Object> vendorProperties) throws LinkageError {
        JtaTransactionManager jtaTransactionManager = this.getJtaTransactionManager();
        if (jtaTransactionManager != null) {
            if (this.runningOnWebSphere()) {
                this.configureWebSphereTransactionPlatform(vendorProperties);
            } else {
                this.configureSpringJtaPlatform(vendorProperties, jtaTransactionManager);
            }
        } else {
            vendorProperties.put(JTA_PLATFORM, this.getNoJtaPlatformManager());
        }
    }

    private boolean runningOnWebSphere() {
        return ClassUtils.isPresent((String)"com.ibm.websphere.jtaextensions.ExtendedJTATransaction", (ClassLoader)this.getClass().getClassLoader());
    }

    private void configureWebSphereTransactionPlatform(Map<String, Object> vendorProperties) {
        vendorProperties.put(JTA_PLATFORM, this.getWebSphereJtaPlatformManager());
    }

    private Object getWebSphereJtaPlatformManager() {
        return this.getJtaPlatformManager(WEBSHERE_JTA_PLATFORM_CLASSES);
    }

    private void configureSpringJtaPlatform(Map<String, Object> vendorProperties, JtaTransactionManager jtaTransactionManager) {
        block3: {
            try {
                vendorProperties.put(JTA_PLATFORM, new SpringJtaPlatform(jtaTransactionManager));
            }
            catch (LinkageError ex) {
                if (!this.isUsingJndi()) {
                    throw new IllegalStateException("Unable to set Hibernate JTA platform, are you using the correct version of Hibernate?", ex);
                }
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)("Unable to set Hibernate JTA platform : " + ex.getMessage()));
            }
        }
    }

    private boolean isUsingJndi() {
        try {
            return JndiLocatorDelegate.isDefaultJndiEnvironmentAvailable();
        }
        catch (Error ex) {
            return false;
        }
    }

    private Object getNoJtaPlatformManager() {
        return this.getJtaPlatformManager(NO_JTA_PLATFORM_CLASSES);
    }

    private Object getJtaPlatformManager(String[] candidates) {
        for (String candidate : candidates) {
            try {
                return Class.forName(candidate).newInstance();
            }
            catch (Exception ex) {
            }
        }
        throw new IllegalStateException("Could not configure JTA platform");
    }

    @Order(value=-2147483628)
    static class HibernateEntityManagerCondition
    extends SpringBootCondition {
        private static String[] CLASS_NAMES = new String[]{"org.hibernate.ejb.HibernateEntityManager", "org.hibernate.jpa.HibernateEntityManager"};

        HibernateEntityManagerCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            for (String className : CLASS_NAMES) {
                if (!ClassUtils.isPresent((String)className, (ClassLoader)context.getClassLoader())) continue;
                return ConditionOutcome.match("found HibernateEntityManager class");
            }
            return ConditionOutcome.noMatch("did not find HibernateEntityManager class");
        }
    }
}

