/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.velocity;

import java.io.IOException;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.servlet.Servlet;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnNotWebApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.template.TemplateLocation;
import org.springframework.boot.autoconfigure.velocity.VelocityProperties;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.view.velocity.EmbeddedVelocityViewResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.ui.velocity.VelocityEngineFactory;
import org.springframework.ui.velocity.VelocityEngineFactoryBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.view.velocity.VelocityConfig;
import org.springframework.web.servlet.view.velocity.VelocityConfigurer;
import org.springframework.web.servlet.view.velocity.VelocityViewResolver;

@Configuration
@ConditionalOnClass(value={VelocityEngine.class, VelocityEngineFactory.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={VelocityProperties.class})
public class VelocityAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private VelocityProperties properties;

    @PostConstruct
    public void checkTemplateLocationExists() {
        if (this.properties.isCheckTemplateLocation()) {
            TemplateLocation location = new TemplateLocation(this.properties.getResourceLoaderPath());
            Assert.state((boolean)location.exists((ResourcePatternResolver)this.applicationContext), (String)("Cannot find template location: " + location + " (please add some templates, check your Velocity " + "configuration, or set spring.velocity." + "checkTemplateLocation=false)"));
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class})
    @ConditionalOnWebApplication
    public static class VelocityWebConfiguration
    extends VelocityConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={VelocityConfig.class})
        public VelocityConfigurer velocityConfigurer() {
            VelocityConfigurer configurer = new VelocityConfigurer();
            this.applyProperties((VelocityEngineFactory)configurer);
            return configurer;
        }

        @Bean
        public VelocityEngine velocityEngine(VelocityConfigurer configurer) throws VelocityException, IOException {
            return configurer.getVelocityEngine();
        }

        @Bean
        @ConditionalOnMissingBean(name={"velocityViewResolver"})
        @ConditionalOnProperty(name={"spring.velocity.enabled"}, matchIfMissing=true)
        public VelocityViewResolver velocityViewResolver() {
            EmbeddedVelocityViewResolver resolver = new EmbeddedVelocityViewResolver();
            this.properties.applyToViewResolver(resolver);
            return resolver;
        }
    }

    @Configuration
    @ConditionalOnNotWebApplication
    public static class VelocityNonWebConfiguration
    extends VelocityConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public VelocityEngineFactoryBean velocityConfiguration() {
            VelocityEngineFactoryBean velocityEngineFactoryBean = new VelocityEngineFactoryBean();
            this.applyProperties((VelocityEngineFactory)velocityEngineFactoryBean);
            return velocityEngineFactoryBean;
        }
    }

    protected static class VelocityConfiguration {
        @Autowired
        protected VelocityProperties properties;

        protected VelocityConfiguration() {
        }

        protected void applyProperties(VelocityEngineFactory factory) {
            factory.setResourceLoaderPath(this.properties.getResourceLoaderPath());
            factory.setPreferFileSystemAccess(this.properties.isPreferFileSystemAccess());
            Properties velocityProperties = new Properties();
            velocityProperties.setProperty("input.encoding", this.properties.getCharset());
            velocityProperties.putAll(this.properties.getProperties());
            factory.setVelocityProperties(velocityProperties);
        }
    }
}

