/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.websocket;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.servlet.Servlet;
import org.apache.catalina.Context;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.context.web.NonEmbeddedServletContainerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.socket.WebSocketHandler;

@Configuration
@ConditionalOnClass(name={"org.apache.tomcat.websocket.server.WsSci"}, value={Servlet.class, Tomcat.class, WebSocketHandler.class})
@AutoConfigureBefore(value={EmbeddedServletContainerAutoConfiguration.class})
public class WebSocketAutoConfiguration {
    private static final String TOMCAT_7_LISTENER_TYPE = "org.apache.catalina.deploy.ApplicationListener";
    private static final String TOMCAT_8_LISTENER_TYPE = "org.apache.tomcat.util.descriptor.web.ApplicationListener";
    private static final String WS_LISTENER = "org.apache.tomcat.websocket.server.WsContextListener";
    private static Log logger = LogFactory.getLog(WebSocketAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(name={"websocketContainerCustomizer"})
    public EmbeddedServletContainerCustomizer websocketContainerCustomizer() {
        return new EmbeddedServletContainerCustomizer(){

            public void customize(ConfigurableEmbeddedServletContainer container) {
                if (container instanceof NonEmbeddedServletContainerFactory) {
                    logger.info((Object)"NonEmbeddedServletContainerFactory detected. Websockets support should be native so this normally is not a problem.");
                    return;
                }
                Assert.state((boolean)(container instanceof TomcatEmbeddedServletContainerFactory), (String)("Websockets are currently only supported in Tomcat (found " + container.getClass() + "). "));
                TomcatEmbeddedServletContainerFactory tomcatContainer = (TomcatEmbeddedServletContainerFactory)container;
                tomcatContainer.addContextCustomizers(new TomcatContextCustomizer[]{new TomcatContextCustomizer(){

                    public void customize(Context context) {
                        WebSocketAutoConfiguration.addListener(context, WebSocketAutoConfiguration.findListenerType());
                    }
                }});
            }
        };
    }

    private static Class<?> findListenerType() {
        if (ClassUtils.isPresent((String)TOMCAT_7_LISTENER_TYPE, null)) {
            return ClassUtils.resolveClassName((String)TOMCAT_7_LISTENER_TYPE, null);
        }
        if (ClassUtils.isPresent((String)TOMCAT_8_LISTENER_TYPE, null)) {
            return ClassUtils.resolveClassName((String)TOMCAT_8_LISTENER_TYPE, null);
        }
        return null;
    }

    private static void addListener(Context context, Class<?> listenerType) {
        if (listenerType == null) {
            ReflectionUtils.invokeMethod((Method)ClassUtils.getMethod(context.getClass(), (String)"addApplicationListener", (Class[])new Class[]{String.class}), (Object)context, (Object[])new Object[]{WS_LISTENER});
        } else {
            Object instance = BeanUtils.instantiateClass((Constructor)ClassUtils.getConstructorIfAvailable(listenerType, (Class[])new Class[]{String.class, Boolean.TYPE}), (Object[])new Object[]{WS_LISTENER, false});
            ReflectionUtils.invokeMethod((Method)ClassUtils.getMethod(context.getClass(), (String)"addApplicationListener", (Class[])new Class[]{listenerType}), (Object)context, (Object[])new Object[]{instance});
        }
    }
}

