/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.redis;

import com.lambdaworks.redis.RedisClient;
import java.net.UnknownHostException;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.PoolConfig;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.DefaultLettucePool;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePool;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
@ConditionalOnClass(value={LettuceConnection.class, RedisOperations.class, RedisClient.class})
@EnableConfigurationProperties
public class RedisAutoConfiguration {
    @Bean(name={"org.springframework.autoconfigure.redis.RedisProperties"})
    @ConditionalOnMissingBean
    public RedisProperties redisProperties() {
        return new RedisProperties();
    }

    @Configuration
    protected static class RedisConfiguration {
        @Autowired
        private RedisProperties properties;

        protected RedisConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"redisTemplate"})
        RedisOperations<Object, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) throws UnknownHostException {
            RedisTemplate template = new RedisTemplate();
            template.setConnectionFactory(redisConnectionFactory);
            return template;
        }

        @Bean
        @ConditionalOnMissingBean(value={StringRedisTemplate.class})
        StringRedisTemplate stringRedisTemplate(RedisConnectionFactory redisConnectionFactory) throws UnknownHostException {
            StringRedisTemplate template = new StringRedisTemplate();
            template.setConnectionFactory(redisConnectionFactory);
            return template;
        }
    }

    @Configuration
    @ConditionalOnClass(value={GenericObjectPool.class})
    protected static class RedisPooledConnectionConfiguration {
        @Autowired
        private RedisProperties properties;

        protected RedisPooledConnectionConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        RedisConnectionFactory redisConnectionFactory() throws UnknownHostException {
            if (this.properties.getPool() != null) {
                LettuceConnectionFactory factory = new LettuceConnectionFactory(this.lettucePool());
                return factory;
            }
            LettuceConnectionFactory factory = new LettuceConnectionFactory(this.properties.getHost(), this.properties.getPort());
            if (this.properties.getPassword() != null) {
                factory.setPassword(this.properties.getPassword());
            }
            return factory;
        }

        @Bean
        @ConditionalOnMissingBean
        public LettucePool lettucePool() {
            return new DefaultLettucePool(this.properties.getHost(), this.properties.getPort(), (GenericObjectPool.Config)this.poolConfig());
        }

        private PoolConfig poolConfig() {
            PoolConfig pool = new PoolConfig();
            RedisProperties.Pool props = this.properties.getPool();
            if (props != null) {
                pool.setMaxActive(props.getMaxActive());
                pool.setMaxIdle(props.getMaxIdle());
                pool.setMinIdle(props.getMinIdle());
                pool.setMaxWait((long)props.getMaxWait());
            }
            return pool;
        }
    }

    @Configuration
    @ConditionalOnMissingClass(name={"org.apache.commons.pool.impl.GenericObjectPool"})
    protected static class RedisConnectionConfiguration {
        @Autowired
        private RedisProperties properties;

        protected RedisConnectionConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        RedisConnectionFactory redisConnectionFactory() throws UnknownHostException {
            LettuceConnectionFactory factory = new LettuceConnectionFactory(this.properties.getHost(), this.properties.getPort());
            if (this.properties.getPassword() != null) {
                factory.setPassword(this.properties.getPassword());
            }
            return factory;
        }
    }
}

