/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.artemis.autoconfigure;

import jakarta.jms.ConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.artemis.autoconfigure.ArtemisConnectionDetails;
import org.springframework.boot.artemis.autoconfigure.ArtemisConnectionFactoryConfiguration;
import org.springframework.boot.artemis.autoconfigure.ArtemisEmbeddedServerConfiguration;
import org.springframework.boot.artemis.autoconfigure.ArtemisMode;
import org.springframework.boot.artemis.autoconfigure.ArtemisProperties;
import org.springframework.boot.artemis.autoconfigure.ArtemisXAConnectionFactoryConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jms.autoconfigure.JmsAutoConfiguration;
import org.springframework.boot.jms.autoconfigure.JmsProperties;
import org.springframework.boot.jms.autoconfigure.JndiConnectionFactoryAutoConfiguration;
import org.springframework.boot.transaction.jta.autoconfigure.JtaAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@AutoConfiguration(before={JmsAutoConfiguration.class}, after={JndiConnectionFactoryAutoConfiguration.class, JtaAutoConfiguration.class})
@ConditionalOnClass(value={ConnectionFactory.class, ActiveMQConnectionFactory.class})
@ConditionalOnMissingBean(value={ConnectionFactory.class})
@EnableConfigurationProperties(value={ArtemisProperties.class, JmsProperties.class})
@Import(value={ArtemisEmbeddedServerConfiguration.class, ArtemisXAConnectionFactoryConfiguration.class, ArtemisConnectionFactoryConfiguration.class})
public final class ArtemisAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    ArtemisConnectionDetails artemisConnectionDetails(ArtemisProperties properties) {
        return new PropertiesArtemisConnectionDetails(properties);
    }

    static class PropertiesArtemisConnectionDetails
    implements ArtemisConnectionDetails {
        private final ArtemisProperties properties;

        PropertiesArtemisConnectionDetails(ArtemisProperties properties) {
            this.properties = properties;
        }

        @Override
        public @Nullable ArtemisMode getMode() {
            return this.properties.getMode();
        }

        @Override
        public @Nullable String getBrokerUrl() {
            return this.properties.getBrokerUrl();
        }

        @Override
        public @Nullable String getUser() {
            return this.properties.getUser();
        }

        @Override
        public @Nullable String getPassword() {
            return this.properties.getPassword();
        }
    }
}

