/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.experimental.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.springframework.boot.experimental.maven.ThinJarMojo;
import org.springframework.util.StringUtils;

@Mojo(name="properties", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.NONE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PropertiesMojo
extends ThinJarMojo {
    private static final String BOMS = "boms.";
    @Parameter(defaultValue="src/main/resources/META-INF", required=true, property="thin.output")
    private File outputDirectory;
    @Parameter(property="thin.compute", defaultValue="true", required=true)
    private boolean compute;
    @Parameter(property="thin.snapshotStyle", defaultValue="TIMESTAMP")
    private SnapshotStyle snapshotStyle;

    public void execute() throws MojoExecutionException {
        if (this.project.getPackaging().equals("pom")) {
            this.getLog().debug((CharSequence)"Thin properties goal could not be applied to pom project.");
            return;
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution");
            return;
        }
        this.getLog().info((CharSequence)("Calculating properties for: " + this.project.getArtifact()));
        Properties props = new Properties();
        this.outputDirectory.mkdirs();
        try {
            File target = new File(this.outputDirectory, "thin.properties");
            if (target.exists()) {
                props.load(new FileInputStream(target));
            }
            props.setProperty("computed", "" + this.compute);
            Enumeration<?> keys = props.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (key.startsWith("dependencies.")) {
                    props.remove(key);
                }
                if (!key.startsWith(BOMS)) continue;
                props.remove(key);
            }
            this.boms(this.project, props);
            Set artifacts = this.compute ? this.project.getArtifacts() : this.project.getDependencyArtifacts();
            for (Artifact artifact : artifacts) {
                if (!"runtime".equals(artifact.getScope()) && !"compile".equals(artifact.getScope())) continue;
                props.setProperty("dependencies." + this.key(artifact, props), this.coordinates(artifact));
            }
            props.store(new FileOutputStream(target), "Enhanced by thin jar maven plugin");
            this.getLog().info((CharSequence)"Saved thin.properties");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot calculate dependencies for: " + this.project.getArtifact(), e);
        }
        this.getLog().info((CharSequence)("Properties ready in: " + this.outputDirectory));
    }

    private String key(Artifact dependency, Properties props) {
        String key = dependency.getArtifactId();
        if (!StringUtils.isEmpty((Object)dependency.getClassifier())) {
            key = key + "." + dependency.getClassifier();
        }
        int counter = 1;
        while (props.get("dependencies." + key) != null) {
            key = key + "." + counter++;
        }
        return key;
    }

    private void boms(MavenProject project, Properties props) {
        while (project != null) {
            String artifactId = project.getArtifactId();
            if (this.isBom(artifactId)) {
                props.setProperty(BOMS + artifactId, this.coordinates(project.getArtifact(), true));
            }
            if (project.getDependencyManagement() != null) {
                for (Dependency dependency : project.getDependencyManagement().getDependencies()) {
                    if (!"import".equals(dependency.getScope())) continue;
                    props.setProperty(BOMS + dependency.getArtifactId(), this.coordinates(dependency));
                }
            }
            project = project.getParent();
        }
    }

    private boolean isBom(String artifactId) {
        return artifactId.endsWith("-dependencies") || artifactId.endsWith("-bom");
    }

    private String coordinates(Dependency dependency) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion();
    }

    private String coordinates(Artifact dependency) {
        return this.coordinates(dependency, this.compute);
    }

    private String coordinates(Artifact artifact, boolean withVersion) {
        String classifier = artifact.getClassifier();
        String extension = artifact.getType();
        String version = this.snapshotStyle.equals((Object)SnapshotStyle.SNAPSHOT) ? artifact.getBaseVersion() : artifact.getVersion();
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + (StringUtils.hasText((String)extension) && (!"jar".equals(extension) || StringUtils.hasText((String)classifier)) ? ":" + extension : "") + (StringUtils.hasText((String)classifier) ? ":" + classifier : "") + (withVersion ? ":" + version : "");
    }

    private static enum SnapshotStyle {
        SNAPSHOT,
        TIMESTAMP;

    }
}

