/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.thin;

import hidden.org.apache.maven.artifact.repository.ArtifactRepository;
import hidden.org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import hidden.org.apache.maven.artifact.repository.Authentication;
import hidden.org.apache.maven.artifact.repository.MavenArtifactRepository;
import hidden.org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import hidden.org.apache.maven.model.Dependency;
import hidden.org.apache.maven.model.Model;
import hidden.org.apache.maven.model.building.ModelSource;
import hidden.org.apache.maven.project.DefaultProjectBuildingRequest;
import hidden.org.apache.maven.project.DependencyResolutionResult;
import hidden.org.apache.maven.project.ProjectBuilder;
import hidden.org.apache.maven.project.ProjectBuildingException;
import hidden.org.apache.maven.project.ProjectBuildingRequest;
import hidden.org.apache.maven.project.ProjectBuildingResult;
import hidden.org.apache.maven.repository.Proxy;
import hidden.org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import hidden.org.apache.maven.settings.Profile;
import hidden.org.apache.maven.settings.Repository;
import hidden.org.eclipse.aether.DefaultRepositoryCache;
import hidden.org.eclipse.aether.DefaultRepositorySystemSession;
import hidden.org.eclipse.aether.RepositorySystem;
import hidden.org.eclipse.aether.RepositorySystemSession;
import hidden.org.eclipse.aether.artifact.Artifact;
import hidden.org.eclipse.aether.artifact.DefaultArtifact;
import hidden.org.eclipse.aether.impl.guice.AetherModule;
import hidden.org.eclipse.aether.repository.AuthenticationContext;
import hidden.org.eclipse.aether.repository.LocalRepository;
import hidden.org.eclipse.aether.repository.MirrorSelector;
import hidden.org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import hidden.org.eclipse.aether.repository.ProxySelector;
import hidden.org.eclipse.aether.repository.RemoteRepository;
import hidden.org.eclipse.aether.repository.RepositoryPolicy;
import hidden.org.eclipse.aether.resolution.ArtifactRequest;
import hidden.org.eclipse.aether.resolution.ArtifactResult;
import hidden.org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import hidden.org.eclipse.aether.util.repository.AuthenticationBuilder;
import hidden.org.eclipse.aether.util.repository.JreProxySelector;
import hidden.org.slf4j.Logger;
import hidden.org.slf4j.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.springframework.boot.loader.thin.CompositeProxySelector;
import org.springframework.boot.loader.thin.DependencyResolutionModule;
import org.springframework.boot.loader.thin.MavenSettings;
import org.springframework.boot.loader.thin.MavenSettingsReader;
import org.springframework.boot.loader.thin.ThinPropertiesModelProcessor;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class DependencyResolver {
    public static final String THIN_OFFLINE = "thin.offline";
    public static final String THIN_ROOT = "thin.root";
    private static final Logger log = LoggerFactory.getLogger(DependencyResolver.class);
    private static DependencyResolver instance = new DependencyResolver();
    private static Properties globals;
    private LocalRepositoryManagerFactory localRepositoryManagerFactory;
    private PlexusContainer container;
    private Object lock = new Object();
    private ProjectBuilder projectBuilder;
    private RepositorySystem repositorySystem;
    private MavenSettings settings;

    public static DependencyResolver instance() {
        return instance;
    }

    public static void close() {
        if (instance != null) {
            instance.dispose();
        }
        instance = new DependencyResolver();
    }

    private void dispose() {
        try {
            if (this.container != null) {
                this.container.dispose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private DependencyResolver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(Properties properties) {
        if (this.container == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.container == null) {
                    DefaultPlexusContainer container;
                    ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
                    ContainerConfiguration config = new DefaultContainerConfiguration().setClassWorld(classWorld).setRealm(classWorld.getClassRealm("plexus.core")).setClassPathScanning("index").setAutoWiring(true).setName("maven");
                    try {
                        container = new DefaultPlexusContainer(config, new AetherModule(), new DependencyResolutionModule());
                        this.localRepositoryManagerFactory = container.lookup(LocalRepositoryManagerFactory.class, "enhanced");
                        this.projectBuilder = container.lookup(ProjectBuilder.class);
                        this.repositorySystem = container.lookup(RepositorySystem.class);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Cannot create container", e);
                    }
                    this.container = container;
                    this.settings = new MavenSettingsReader(properties.getProperty(THIN_ROOT)).readSettings();
                }
            }
        }
    }

    public List<hidden.org.eclipse.aether.graph.Dependency> dependencies(Resource resource) {
        return this.dependencies(resource, new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<hidden.org.eclipse.aether.graph.Dependency> dependencies(Resource resource, Properties properties) {
        if ("true".equals(properties.getProperty("computed", "false"))) {
            log.info("Dependencies are pre-computed in properties");
            Model model = new Model();
            model = ThinPropertiesModelProcessor.process(model, properties);
            return this.aetherDependencies(model.getDependencies(), properties);
        }
        this.initialize(properties);
        try {
            log.info("Computing dependencies from pom and properties");
            ProjectBuildingRequest request = this.getProjectBuildingRequest(properties);
            request.setResolveDependencies(true);
            Class<DependencyResolver> clazz = DependencyResolver.class;
            synchronized (DependencyResolver.class) {
                ProjectBuildingResult result = this.projectBuilder.build(new PropertiesModelSource(properties, resource), request);
                globals = null;
                DependencyResolutionResult dependencies = result.getDependencyResolutionResult();
                if (!dependencies.getUnresolvedDependencies().isEmpty() && properties.getProperty("thin.libs", "").length() == 0) {
                    StringBuilder builder = new StringBuilder();
                    for (hidden.org.eclipse.aether.graph.Dependency dependency : dependencies.getUnresolvedDependencies()) {
                        List<Exception> errors = dependencies.getResolutionErrors(dependency);
                        for (Exception exception : errors) {
                            if (builder.length() > 0) {
                                builder.append("\n");
                            }
                            builder.append(exception.getMessage());
                        }
                    }
                    throw new RuntimeException(builder.toString());
                }
                if (!dependencies.getCollectionErrors().isEmpty()) {
                    StringBuilder builder = new StringBuilder();
                    for (Exception exception : dependencies.getCollectionErrors()) {
                        if (builder.length() > 0) {
                            builder.append("\n");
                        }
                        builder.append(exception.getMessage());
                    }
                    throw new RuntimeException(builder.toString());
                }
                List<hidden.org.eclipse.aether.graph.Dependency> output = this.runtime(dependencies.getDependencies());
                if (log.isInfoEnabled()) {
                    for (hidden.org.eclipse.aether.graph.Dependency dependency : output) {
                        log.info("Resolved: " + this.coordinates(dependency) + "=" + dependency.getArtifact().getFile());
                    }
                }
                // ** MonitorExit[var4_6] (shouldn't be in output)
                return output;
            }
        }
        catch (ProjectBuildingException | NoLocalRepositoryManagerException e) {
            throw new IllegalStateException("Cannot build model", e);
        }
    }

    private List<hidden.org.eclipse.aether.graph.Dependency> aetherDependencies(List<Dependency> dependencies, Properties properties) {
        ArrayList<hidden.org.eclipse.aether.graph.Dependency> list = new ArrayList<hidden.org.eclipse.aether.graph.Dependency>();
        for (Dependency dependency : dependencies) {
            DefaultArtifact artifact = new DefaultArtifact(this.coordinates(dependency));
            hidden.org.eclipse.aether.graph.Dependency converted = new hidden.org.eclipse.aether.graph.Dependency(artifact, "runtime");
            list.add(converted);
        }
        this.initialize(properties);
        List<ArtifactResult> result = this.collectNonTransitive(list, properties);
        list = new ArrayList();
        for (ArtifactResult item : result) {
            Artifact artifact = item.getArtifact();
            hidden.org.eclipse.aether.graph.Dependency converted = new hidden.org.eclipse.aether.graph.Dependency(artifact, "runtime");
            list.add(converted);
        }
        return list;
    }

    private String coordinates(Dependency artifact) {
        String classifier = artifact.getClassifier();
        String extension = artifact.getType();
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + (extension != null ? ":" + extension : "") + (classifier != null ? ":" + classifier : "") + ":" + artifact.getVersion();
    }

    private String coordinates(hidden.org.eclipse.aether.graph.Dependency dependency) {
        Artifact artifact = dependency.getArtifact();
        String classifier = artifact.getClassifier();
        String extension = artifact.getExtension();
        if ("jar".equals(extension) && !StringUtils.hasText(classifier)) {
            extension = null;
        }
        boolean hasExtension = extension != null && !"jar".equals(extension);
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + (hasExtension ? ":" + extension : "") + (StringUtils.hasText(classifier) ? ":" + classifier : "") + ":" + artifact.getVersion();
    }

    public File getLocalRepository() {
        this.initialize(new Properties());
        return this.localRepositoryPath(new Properties(), this.settings);
    }

    public File resolve(hidden.org.eclipse.aether.graph.Dependency dependency) {
        Properties properties = new Properties();
        this.initialize(properties);
        return this.collectNonTransitive(Arrays.asList(dependency), properties).iterator().next().getArtifact().getFile();
    }

    private List<hidden.org.eclipse.aether.graph.Dependency> runtime(List<hidden.org.eclipse.aether.graph.Dependency> dependencies) {
        ArrayList<hidden.org.eclipse.aether.graph.Dependency> list = new ArrayList<hidden.org.eclipse.aether.graph.Dependency>();
        for (hidden.org.eclipse.aether.graph.Dependency dependency : dependencies) {
            if ("test".equals(dependency.getScope()) || "provided".equals(dependency.getScope())) continue;
            list.add(dependency);
        }
        return list;
    }

    private ProjectBuildingRequest getProjectBuildingRequest(Properties properties) throws NoLocalRepositoryManagerException {
        String property;
        DefaultProjectBuildingRequest projectBuildingRequest = new DefaultProjectBuildingRequest();
        DefaultRepositorySystemSession session = this.createSession(properties);
        projectBuildingRequest.setRepositoryMerging(ProjectBuildingRequest.RepositoryMerging.REQUEST_DOMINANT);
        projectBuildingRequest.setRemoteRepositories(this.mavenRepositories(this.settings, session, properties));
        projectBuildingRequest.setLocalRepository(this.localArtifactRepository(properties, this.settings, session));
        projectBuildingRequest.setRepositorySession(session);
        projectBuildingRequest.setProcessPlugins(false);
        projectBuildingRequest.setBuildStartTime(new Date());
        projectBuildingRequest.setUserProperties(properties);
        projectBuildingRequest.setSystemProperties(System.getProperties());
        LinkedHashSet<String> profiles = new LinkedHashSet<String>();
        for (Profile profile : this.settings.getActiveProfiles()) {
            profiles.add(profile.getId());
        }
        if (properties.containsKey("thin.profile") && (property = properties.getProperty("thin.profile")).length() > 0) {
            profiles.addAll(StringUtils.commaDelimitedListToSet(property));
        }
        if (!profiles.isEmpty()) {
            projectBuildingRequest.setActiveProfileIds(new ArrayList<String>(profiles));
        }
        return projectBuildingRequest;
    }

    private List<ArtifactRepository> mavenRepositories(MavenSettings settings, RepositorySystemSession session, Properties properties) {
        ArrayList<ArtifactRepository> list = new ArrayList<ArtifactRepository>();
        if (session.isOffline()) {
            if (properties.containsKey(THIN_ROOT)) {
                this.addRepositoryIfMissing(settings, session, list, "local", "file://" + properties.getProperty(THIN_ROOT), true, true);
            }
            return list;
        }
        if (properties.containsKey(THIN_ROOT)) {
            this.addRepositoryIfMissing(settings, session, list, "local", "file://" + this.localRepositoryPath(new Properties(), settings), true, true);
        }
        for (Profile profile : settings.getActiveProfiles()) {
            for (Repository repository : profile.getRepositories()) {
                this.addRepositoryIfMissing(settings, session, list, repository.getId(), repository.getUrl(), repository.getReleases() != null ? repository.getReleases().isEnabled() : true, repository.getSnapshots() != null ? repository.getSnapshots().isEnabled() : true);
            }
        }
        this.addRepositoryIfMissing(settings, session, list, "spring-snapshots", "https://repo.spring.io/snapshot", true, true);
        this.addRepositoryIfMissing(settings, session, list, "central", "https://repo1.maven.org/maven2", true, false);
        return list;
    }

    private List<RemoteRepository> aetherRepositories(MavenSettings settings, RepositorySystemSession session, Properties properties) {
        ArrayList<RemoteRepository> list = new ArrayList<RemoteRepository>();
        for (ArtifactRepository input : this.mavenRepositories(settings, session, properties)) {
            list.add(this.aetherRepository(input));
        }
        return list;
    }

    private RemoteRepository aetherRepository(ArtifactRepository input) {
        hidden.org.eclipse.aether.repository.Proxy proxy = this.proxy(input);
        RemoteRepository.Builder builder = new RemoteRepository.Builder(input.getId(), input.getLayout().getId(), input.getUrl()).setSnapshotPolicy(this.policy(input.getSnapshots())).setReleasePolicy(this.policy(input.getReleases()));
        if (proxy != null) {
            builder = builder.setProxy(proxy);
        }
        return builder.build();
    }

    private hidden.org.eclipse.aether.repository.Proxy proxy(ArtifactRepository repo) {
        Proxy proxy = repo.getProxy();
        if (proxy == null) {
            return null;
        }
        hidden.org.eclipse.aether.repository.Authentication authentication = new AuthenticationBuilder().addUsername(proxy.getUserName()).addPassword(proxy.getPassword()).build();
        return new hidden.org.eclipse.aether.repository.Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), authentication);
    }

    private RepositoryPolicy policy(ArtifactRepositoryPolicy input) {
        RepositoryPolicy policy = new RepositoryPolicy(input.isEnabled(), "daily", "warn");
        return policy;
    }

    private void addRepositoryIfMissing(MavenSettings settings, RepositorySystemSession session, List<ArtifactRepository> list, String id, String url, boolean releases, boolean snapshots) {
        for (ArtifactRepository repo : list) {
            if (url.equals(repo.getUrl())) {
                return;
            }
            if (!id.equals(repo.getId())) continue;
            return;
        }
        list.add(this.repo(settings, session, id, url, releases, snapshots));
    }

    private ArtifactRepository repo(MavenSettings settings, RepositorySystemSession session, String id, String url, boolean releases, boolean snapshots) {
        Proxy value;
        ProxySelector proxy;
        hidden.org.eclipse.aether.repository.Authentication authentication;
        RemoteRepository value2;
        MavenArtifactRepository repository = new MavenArtifactRepository();
        repository.setLayout(new DefaultRepositoryLayout());
        repository.setId(id);
        repository.setUrl(url);
        ArtifactRepositoryPolicy enabled = new ArtifactRepositoryPolicy();
        enabled.setEnabled(true);
        ArtifactRepositoryPolicy disabled = new ArtifactRepositoryPolicy();
        disabled.setEnabled(false);
        repository.setReleaseUpdatePolicy(releases ? enabled : disabled);
        repository.setSnapshotUpdatePolicy(snapshots ? enabled : disabled);
        RemoteRepository remote = new RemoteRepository.Builder(id, null, url).setContentType(repository.getLayout().getId()).build();
        MirrorSelector mirror = settings.getMirrorSelector();
        if (mirror != null && (value2 = mirror.getMirror(remote)) != null) {
            remote = value2;
        }
        if ((authentication = settings.getAuthenticationSelector().getAuthentication(remote)) != null) {
            remote = new RemoteRepository.Builder(remote).setAuthentication(authentication).build();
            repository.setAuthentication(this.authentication(settings, session, remote, authentication));
        }
        if ((proxy = settings.getProxySelector()) != null && (value = this.proxy(settings, session, remote, proxy)) != null) {
            repository.setProxy(value);
        }
        return repository;
    }

    private Proxy proxy(MavenSettings settings, RepositorySystemSession session, RemoteRepository remote, ProxySelector proxy) {
        hidden.org.eclipse.aether.repository.Proxy config = proxy.getProxy(remote);
        if (config == null) {
            return null;
        }
        Proxy result = new Proxy();
        result.setHost(config.getHost());
        if (config.getAuthentication() != null) {
            Authentication auth = this.authentication(settings, session, new RemoteRepository.Builder(remote).setAuthentication(config.getAuthentication()).build(), config.getAuthentication());
            result.setUserName(auth.getUsername());
            result.setPassword(auth.getPassword() != null ? auth.getPassword() : auth.getPassphrase());
        }
        result.setProtocol(config.getType());
        result.setPort(config.getPort());
        return result;
    }

    private Authentication authentication(MavenSettings settings, RepositorySystemSession session, RemoteRepository remote, hidden.org.eclipse.aether.repository.Authentication authentication) {
        AuthenticationContext context = AuthenticationContext.forRepository(session, remote);
        if (context == null) {
            return null;
        }
        authentication.fill(context, "username", Collections.emptyMap());
        authentication.fill(context, "password", Collections.emptyMap());
        authentication.fill(context, "passphrase", Collections.emptyMap());
        authentication.fill(context, "privateKey", Collections.emptyMap());
        Authentication maven = new Authentication(context.get("username"), context.get("password"));
        if (context.get("passphrase") != null) {
            maven.setPassphrase(context.get("passphrase"));
        }
        if (context.get("privateKey") != null) {
            maven.setPrivateKey(context.get("privateKey"));
        }
        return maven;
    }

    private DefaultRepositorySystemSession createSession(Properties properties) throws NoLocalRepositoryManagerException {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository repository = this.localRepository(properties);
        session.setLocalRepositoryManager(this.localRepositoryManagerFactory.newInstance(session, repository));
        this.applySettings(session);
        ProxySelector existing = session.getProxySelector();
        if (existing == null || !(existing instanceof CompositeProxySelector)) {
            JreProxySelector fallback = new JreProxySelector();
            ProxySelector selector = existing == null ? fallback : new CompositeProxySelector(Arrays.asList(existing, fallback));
            session.setProxySelector(selector);
        }
        if (properties.containsKey(THIN_OFFLINE) && !"false".equals(properties.getProperty(THIN_OFFLINE))) {
            session.setOffline(true);
        }
        session.setCache(new DefaultRepositoryCache());
        return session;
    }

    private void applySettings(DefaultRepositorySystemSession session) {
        MavenSettingsReader.applySettings(this.settings, session);
    }

    private LocalRepository localRepository(Properties properties) {
        return new LocalRepository(this.localRepositoryPath(properties, this.settings));
    }

    private ArtifactRepository localArtifactRepository(Properties properties, MavenSettings settings, DefaultRepositorySystemSession session) {
        try {
            return this.repo(settings, session, "cache", this.localRepositoryPath(properties, settings).toURI().toURL().toString(), true, true);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Cannot locate local repo", e);
        }
    }

    private File localRepositoryPath(Properties properties, MavenSettings settings) {
        if (!properties.containsKey(THIN_ROOT)) {
            if (settings != null && StringUtils.hasText(settings.getLocalRepository())) {
                return new File(settings.getLocalRepository());
            }
            return this.getM2RepoDirectory();
        }
        String root = properties.getProperty(THIN_ROOT);
        return new File(StringUtils.cleanPath(root + "/repository"));
    }

    public Model readModel(Resource resource) {
        return this.readModel(resource, new Properties());
    }

    public Model readModel(Resource resource, Properties properties) {
        this.initialize(properties);
        try {
            ProjectBuildingRequest request = this.getProjectBuildingRequest(properties);
            request.setResolveDependencies(false);
            ProjectBuildingResult result = this.projectBuilder.build(new PropertiesModelSource(properties, resource), request);
            return result.getProject().getModel();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to build model from effective pom", e);
        }
    }

    private File getM2RepoDirectory() {
        String mavenRoot = System.getProperty("maven.repo.local");
        if (StringUtils.hasLength(mavenRoot)) {
            return new File(mavenRoot);
        }
        return new File(this.getDefaultM2HomeDirectory(), "repository");
    }

    private File getDefaultM2HomeDirectory() {
        String mavenRoot = System.getProperty("maven.home");
        if (StringUtils.hasLength(mavenRoot)) {
            return new File(mavenRoot);
        }
        return new File(System.getProperty("user.home"), ".m2");
    }

    private List<ArtifactResult> collectNonTransitive(List<hidden.org.eclipse.aether.graph.Dependency> dependencies, Properties properties) {
        try {
            DefaultRepositorySystemSession session = this.createSession(properties);
            List<ArtifactRequest> artifactRequests = this.getArtifactRequests(dependencies, session, properties);
            List<ArtifactResult> result = this.repositorySystem.resolveArtifacts(session, artifactRequests);
            return result;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private List<ArtifactRequest> getArtifactRequests(List<hidden.org.eclipse.aether.graph.Dependency> dependencies, RepositorySystemSession session, Properties properties) {
        ArrayList<ArtifactRequest> list = new ArrayList<ArtifactRequest>();
        for (hidden.org.eclipse.aether.graph.Dependency dependency : dependencies) {
            ArtifactRequest request = new ArtifactRequest(dependency.getArtifact(), null, null);
            request.setRepositories(this.aetherRepositories(this.settings, session, properties));
            list.add(request);
        }
        return list;
    }

    static Properties getGlobals() {
        return globals;
    }

    private static final class PropertiesModelSource
    implements ModelSource {
        private final Properties properties;
        private final Resource resource;

        private PropertiesModelSource(Properties properties, Resource resource) {
            this.properties = properties;
            this.resource = resource;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            globals = this.properties;
            return new BufferedInputStream(this.resource.getInputStream()){

                @Override
                public void close() throws IOException {
                    globals = null;
                    super.close();
                }
            };
        }

        @Override
        public String getLocation() {
            return this.resource.getDescription();
        }
    }
}

