/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.aether.internal.impl;

import hidden.org.eclipse.aether.RepositorySystem;
import hidden.org.eclipse.aether.RepositorySystemSession;
import hidden.org.eclipse.aether.RequestTrace;
import hidden.org.eclipse.aether.SyncContext;
import hidden.org.eclipse.aether.artifact.Artifact;
import hidden.org.eclipse.aether.collection.CollectRequest;
import hidden.org.eclipse.aether.collection.CollectResult;
import hidden.org.eclipse.aether.collection.DependencyCollectionException;
import hidden.org.eclipse.aether.deployment.DeployRequest;
import hidden.org.eclipse.aether.deployment.DeployResult;
import hidden.org.eclipse.aether.deployment.DeploymentException;
import hidden.org.eclipse.aether.graph.DependencyFilter;
import hidden.org.eclipse.aether.graph.DependencyVisitor;
import hidden.org.eclipse.aether.impl.ArtifactDescriptorReader;
import hidden.org.eclipse.aether.impl.ArtifactResolver;
import hidden.org.eclipse.aether.impl.DependencyCollector;
import hidden.org.eclipse.aether.impl.Deployer;
import hidden.org.eclipse.aether.impl.Installer;
import hidden.org.eclipse.aether.impl.LocalRepositoryProvider;
import hidden.org.eclipse.aether.impl.MetadataResolver;
import hidden.org.eclipse.aether.impl.RemoteRepositoryManager;
import hidden.org.eclipse.aether.impl.SyncContextFactory;
import hidden.org.eclipse.aether.impl.VersionRangeResolver;
import hidden.org.eclipse.aether.impl.VersionResolver;
import hidden.org.eclipse.aether.installation.InstallRequest;
import hidden.org.eclipse.aether.installation.InstallResult;
import hidden.org.eclipse.aether.installation.InstallationException;
import hidden.org.eclipse.aether.internal.impl.ArtifactRequestBuilder;
import hidden.org.eclipse.aether.repository.Authentication;
import hidden.org.eclipse.aether.repository.LocalRepository;
import hidden.org.eclipse.aether.repository.LocalRepositoryManager;
import hidden.org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import hidden.org.eclipse.aether.repository.Proxy;
import hidden.org.eclipse.aether.repository.RemoteRepository;
import hidden.org.eclipse.aether.resolution.ArtifactDescriptorException;
import hidden.org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import hidden.org.eclipse.aether.resolution.ArtifactDescriptorResult;
import hidden.org.eclipse.aether.resolution.ArtifactRequest;
import hidden.org.eclipse.aether.resolution.ArtifactResolutionException;
import hidden.org.eclipse.aether.resolution.ArtifactResult;
import hidden.org.eclipse.aether.resolution.DependencyRequest;
import hidden.org.eclipse.aether.resolution.DependencyResolutionException;
import hidden.org.eclipse.aether.resolution.DependencyResult;
import hidden.org.eclipse.aether.resolution.MetadataRequest;
import hidden.org.eclipse.aether.resolution.MetadataResult;
import hidden.org.eclipse.aether.resolution.VersionRangeRequest;
import hidden.org.eclipse.aether.resolution.VersionRangeResolutionException;
import hidden.org.eclipse.aether.resolution.VersionRangeResult;
import hidden.org.eclipse.aether.resolution.VersionRequest;
import hidden.org.eclipse.aether.resolution.VersionResolutionException;
import hidden.org.eclipse.aether.resolution.VersionResult;
import hidden.org.eclipse.aether.spi.locator.Service;
import hidden.org.eclipse.aether.spi.locator.ServiceLocator;
import hidden.org.eclipse.aether.spi.log.Logger;
import hidden.org.eclipse.aether.spi.log.LoggerFactory;
import hidden.org.eclipse.aether.spi.log.NullLoggerFactory;
import hidden.org.eclipse.aether.util.graph.visitor.FilteringDependencyVisitor;
import hidden.org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class DefaultRepositorySystem
implements RepositorySystem,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private VersionResolver versionResolver;
    private VersionRangeResolver versionRangeResolver;
    private ArtifactResolver artifactResolver;
    private MetadataResolver metadataResolver;
    private ArtifactDescriptorReader artifactDescriptorReader;
    private DependencyCollector dependencyCollector;
    private Installer installer;
    private Deployer deployer;
    private LocalRepositoryProvider localRepositoryProvider;
    private SyncContextFactory syncContextFactory;
    private RemoteRepositoryManager remoteRepositoryManager;

    public DefaultRepositorySystem() {
    }

    @Inject
    DefaultRepositorySystem(VersionResolver versionResolver, VersionRangeResolver versionRangeResolver, ArtifactResolver artifactResolver, MetadataResolver metadataResolver, ArtifactDescriptorReader artifactDescriptorReader, DependencyCollector dependencyCollector, Installer installer, Deployer deployer, LocalRepositoryProvider localRepositoryProvider, SyncContextFactory syncContextFactory, RemoteRepositoryManager remoteRepositoryManager, LoggerFactory loggerFactory) {
        this.setVersionResolver(versionResolver);
        this.setVersionRangeResolver(versionRangeResolver);
        this.setArtifactResolver(artifactResolver);
        this.setMetadataResolver(metadataResolver);
        this.setArtifactDescriptorReader(artifactDescriptorReader);
        this.setDependencyCollector(dependencyCollector);
        this.setInstaller(installer);
        this.setDeployer(deployer);
        this.setLocalRepositoryProvider(localRepositoryProvider);
        this.setSyncContextFactory(syncContextFactory);
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setLoggerFactory(loggerFactory);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.setVersionResolver(locator.getService(VersionResolver.class));
        this.setVersionRangeResolver(locator.getService(VersionRangeResolver.class));
        this.setArtifactResolver(locator.getService(ArtifactResolver.class));
        this.setMetadataResolver(locator.getService(MetadataResolver.class));
        this.setArtifactDescriptorReader(locator.getService(ArtifactDescriptorReader.class));
        this.setDependencyCollector(locator.getService(DependencyCollector.class));
        this.setInstaller(locator.getService(Installer.class));
        this.setDeployer(locator.getService(Deployer.class));
        this.setLocalRepositoryProvider(locator.getService(LocalRepositoryProvider.class));
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
    }

    public DefaultRepositorySystem setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    public DefaultRepositorySystem setVersionResolver(VersionResolver versionResolver) {
        this.versionResolver = Objects.requireNonNull(versionResolver, "version resolver cannot be null");
        return this;
    }

    public DefaultRepositorySystem setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        this.versionRangeResolver = Objects.requireNonNull(versionRangeResolver, "version range resolver cannot be null");
        return this;
    }

    public DefaultRepositorySystem setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = Objects.requireNonNull(artifactResolver, "artifact resolver cannot be null");
        return this;
    }

    public DefaultRepositorySystem setMetadataResolver(MetadataResolver metadataResolver) {
        this.metadataResolver = Objects.requireNonNull(metadataResolver, "metadata resolver cannot be null");
        return this;
    }

    public DefaultRepositorySystem setArtifactDescriptorReader(ArtifactDescriptorReader artifactDescriptorReader) {
        this.artifactDescriptorReader = Objects.requireNonNull(artifactDescriptorReader, "artifact descriptor reader cannot be null");
        return this;
    }

    public DefaultRepositorySystem setDependencyCollector(DependencyCollector dependencyCollector) {
        this.dependencyCollector = Objects.requireNonNull(dependencyCollector, "dependency collector cannot be null");
        return this;
    }

    public DefaultRepositorySystem setInstaller(Installer installer) {
        this.installer = Objects.requireNonNull(installer, "installer cannot be null");
        return this;
    }

    public DefaultRepositorySystem setDeployer(Deployer deployer) {
        this.deployer = Objects.requireNonNull(deployer, "deployer cannot be null");
        return this;
    }

    public DefaultRepositorySystem setLocalRepositoryProvider(LocalRepositoryProvider localRepositoryProvider) {
        this.localRepositoryProvider = Objects.requireNonNull(localRepositoryProvider, "local repository provider cannot be null");
        return this;
    }

    public DefaultRepositorySystem setSyncContextFactory(SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "sync context factory cannot be null");
        return this;
    }

    public DefaultRepositorySystem setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remote repository provider cannot be null");
        return this;
    }

    @Override
    public VersionResult resolveVersion(RepositorySystemSession session, VersionRequest request) throws VersionResolutionException {
        this.validateSession(session);
        return this.versionResolver.resolveVersion(session, request);
    }

    @Override
    public VersionRangeResult resolveVersionRange(RepositorySystemSession session, VersionRangeRequest request) throws VersionRangeResolutionException {
        this.validateSession(session);
        return this.versionRangeResolver.resolveVersionRange(session, request);
    }

    @Override
    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        this.validateSession(session);
        return this.artifactDescriptorReader.readArtifactDescriptor(session, request);
    }

    @Override
    public ArtifactResult resolveArtifact(RepositorySystemSession session, ArtifactRequest request) throws ArtifactResolutionException {
        this.validateSession(session);
        return this.artifactResolver.resolveArtifact(session, request);
    }

    @Override
    public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        this.validateSession(session);
        return this.artifactResolver.resolveArtifacts(session, requests);
    }

    @Override
    public List<MetadataResult> resolveMetadata(RepositorySystemSession session, Collection<? extends MetadataRequest> requests) {
        this.validateSession(session);
        return this.metadataResolver.resolveMetadata(session, requests);
    }

    @Override
    public CollectResult collectDependencies(RepositorySystemSession session, CollectRequest request) throws DependencyCollectionException {
        this.validateSession(session);
        return this.dependencyCollector.collectDependencies(session, request);
    }

    @Override
    public DependencyResult resolveDependencies(RepositorySystemSession session, DependencyRequest request) throws DependencyResolutionException {
        List<ArtifactResult> results;
        this.validateSession(session);
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        DependencyResult result = new DependencyResult(request);
        DependencyCollectionException dce = null;
        ArtifactResolutionException are = null;
        if (request.getRoot() != null) {
            result.setRoot(request.getRoot());
        } else if (request.getCollectRequest() != null) {
            CollectResult collectResult;
            try {
                request.getCollectRequest().setTrace(trace);
                collectResult = this.dependencyCollector.collectDependencies(session, request.getCollectRequest());
            }
            catch (DependencyCollectionException e) {
                dce = e;
                collectResult = e.getResult();
            }
            result.setRoot(collectResult.getRoot());
            result.setCycles(collectResult.getCycles());
            result.setCollectExceptions(collectResult.getExceptions());
        } else {
            throw new NullPointerException("dependency node and collect request cannot be null");
        }
        ArtifactRequestBuilder builder = new ArtifactRequestBuilder(trace);
        DependencyFilter filter = request.getFilter();
        DependencyVisitor visitor = filter != null ? new FilteringDependencyVisitor(builder, filter) : builder;
        visitor = new TreeDependencyVisitor(visitor);
        if (result.getRoot() != null) {
            result.getRoot().accept(visitor);
        }
        List<ArtifactRequest> requests = builder.getRequests();
        try {
            results = this.artifactResolver.resolveArtifacts(session, requests);
        }
        catch (ArtifactResolutionException e) {
            are = e;
            results = e.getResults();
        }
        result.setArtifactResults(results);
        this.updateNodesWithResolvedArtifacts(results);
        if (dce != null) {
            throw new DependencyResolutionException(result, (Throwable)dce);
        }
        if (are != null) {
            throw new DependencyResolutionException(result, (Throwable)are);
        }
        return result;
    }

    private void updateNodesWithResolvedArtifacts(List<ArtifactResult> results) {
        for (ArtifactResult result : results) {
            Artifact artifact = result.getArtifact();
            if (artifact == null) continue;
            result.getRequest().getDependencyNode().setArtifact(artifact);
        }
    }

    @Override
    public InstallResult install(RepositorySystemSession session, InstallRequest request) throws InstallationException {
        this.validateSession(session);
        return this.installer.install(session, request);
    }

    @Override
    public DeployResult deploy(RepositorySystemSession session, DeployRequest request) throws DeploymentException {
        this.validateSession(session);
        return this.deployer.deploy(session, request);
    }

    @Override
    public LocalRepositoryManager newLocalRepositoryManager(RepositorySystemSession session, LocalRepository localRepository) {
        try {
            return this.localRepositoryProvider.newLocalRepositoryManager(session, localRepository);
        }
        catch (NoLocalRepositoryManagerException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public SyncContext newSyncContext(RepositorySystemSession session, boolean shared) {
        this.validateSession(session);
        return this.syncContextFactory.newInstance(session, shared);
    }

    @Override
    public List<RemoteRepository> newResolutionRepositories(RepositorySystemSession session, List<RemoteRepository> repositories) {
        this.validateSession(session);
        repositories = this.remoteRepositoryManager.aggregateRepositories(session, new ArrayList<RemoteRepository>(), repositories, true);
        return repositories;
    }

    @Override
    public RemoteRepository newDeploymentRepository(RepositorySystemSession session, RemoteRepository repository) {
        this.validateSession(session);
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repository);
        Authentication auth = session.getAuthenticationSelector().getAuthentication(repository);
        builder.setAuthentication(auth);
        Proxy proxy = session.getProxySelector().getProxy(repository);
        builder.setProxy(proxy);
        return builder.build();
    }

    private void validateSession(RepositorySystemSession session) {
        Objects.requireNonNull(session, "repository system session cannot be null");
        this.invalidSession(session.getLocalRepositoryManager(), "local repository manager");
        this.invalidSession(session.getSystemProperties(), "system properties");
        this.invalidSession(session.getUserProperties(), "user properties");
        this.invalidSession(session.getConfigProperties(), "config properties");
        this.invalidSession(session.getMirrorSelector(), "mirror selector");
        this.invalidSession(session.getProxySelector(), "proxy selector");
        this.invalidSession(session.getAuthenticationSelector(), "authentication selector");
        this.invalidSession(session.getArtifactTypeRegistry(), "artifact type registry");
        this.invalidSession(session.getData(), "data");
    }

    private void invalidSession(Object obj, String name) {
        Objects.requireNonNull(obj, "repository system session's " + name + " cannot be null");
    }
}

